package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Jianyipeizhi3;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IJianyipeizhi3Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * jianyipeizhi3前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Jianyipeizhi3Controller {

  @Autowired
  private IJianyipeizhi3Service jianyipeizhi3ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param jianyipeizhi3 jianyipeizhi3
   * @return
   */
  @GetMapping("/jianyipeizhi3s" )
  public XfR getJianyipeizhi3s(XfPage page, Jianyipeizhi3 jianyipeizhi3) {
    return XfR.ok(jianyipeizhi3ServiceImpl.page(page, Wrappers.query(jianyipeizhi3)));
  }

  /**
   * 通过id查询jianyipeizhi3
   * @param  id
   * @return XfR
   */
  @GetMapping("/jianyipeizhi3s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(jianyipeizhi3ServiceImpl.getById(id));
  }

  /**
   * 新增jianyipeizhi3
   * @param jianyipeizhi3 jianyipeizhi3
   * @return XfR
   */
  @PostMapping("/jianyipeizhi3s")
  public XfR save(@RequestBody Jianyipeizhi3 jianyipeizhi3) {
     return XfR.ok(jianyipeizhi3ServiceImpl.save(jianyipeizhi3));
  }

  /**
   * 修改-传入修改后的全部数据jianyipeizhi3
   * @param jianyipeizhi3 jianyipeizhi3
   * @return XfR
   */
  @PutMapping("/jianyipeizhi3s/{id}")
  public XfR putUpdate(@RequestBody Jianyipeizhi3 jianyipeizhi3,@PathVariable Long id) {
      jianyipeizhi3.setId(id);
      return XfR.ok(jianyipeizhi3ServiceImpl.updateById(jianyipeizhi3));
  }

  /**
   * 修改-传入修改的数据jianyipeizhi3
   * @param jianyipeizhi3 jianyipeizhi3
   * @return XfR
   */
  @PatchMapping("/jianyipeizhi3s/{id}")
  public XfR patchUpdate(@RequestBody Jianyipeizhi3 jianyipeizhi3,@PathVariable Long id) {
      Jianyipeizhi3 upjianyipeizhi3 = jianyipeizhi3ServiceImpl.getById(id);
      if(upjianyipeizhi3 != null){
        upjianyipeizhi3 = ObjectCopyUtils.copyProperties(jianyipeizhi3,upjianyipeizhi3,true);
      }
      return XfR.ok(jianyipeizhi3ServiceImpl.updateById(upjianyipeizhi3));
  }

  /**
   * 通过id删除jianyipeizhi3
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/jianyipeizhi3s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(jianyipeizhi3ServiceImpl.removeById(id));
  }

  @PostMapping("/jianyipeizhi3s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "jianyipeizhi3");
     params.put("request", condition);

     return XfR.ok(jianyipeizhi3ServiceImpl.querys(params));
  }

}
