package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Jianyipeizhi;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IJianyipeizhiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 简易配置前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class JianyipeizhiController {

  @Autowired
  private IJianyipeizhiService jianyipeizhiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param jianyipeizhi 简易配置
   * @return
   */
  @GetMapping("/jianyipeizhis" )
  public XfR getJianyipeizhis(XfPage page, Jianyipeizhi jianyipeizhi) {
    return XfR.ok(jianyipeizhiServiceImpl.page(page, Wrappers.query(jianyipeizhi)));
  }

  /**
   * 通过id查询简易配置
   * @param  id
   * @return XfR
   */
  @GetMapping("/jianyipeizhis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(jianyipeizhiServiceImpl.getById(id));
  }

  /**
   * 新增简易配置
   * @param jianyipeizhi 简易配置
   * @return XfR
   */
  @PostMapping("/jianyipeizhis")
  public XfR save(@RequestBody Jianyipeizhi jianyipeizhi) {
     return XfR.ok(jianyipeizhiServiceImpl.save(jianyipeizhi));
  }

  /**
   * 修改-传入修改后的全部数据简易配置
   * @param jianyipeizhi 简易配置
   * @return XfR
   */
  @PutMapping("/jianyipeizhis/{id}")
  public XfR putUpdate(@RequestBody Jianyipeizhi jianyipeizhi,@PathVariable Long id) {
      jianyipeizhi.setId(id);
      return XfR.ok(jianyipeizhiServiceImpl.updateById(jianyipeizhi));
  }

  /**
   * 修改-传入修改的数据简易配置
   * @param jianyipeizhi 简易配置
   * @return XfR
   */
  @PatchMapping("/jianyipeizhis/{id}")
  public XfR patchUpdate(@RequestBody Jianyipeizhi jianyipeizhi,@PathVariable Long id) {
      Jianyipeizhi upjianyipeizhi = jianyipeizhiServiceImpl.getById(id);
      if(upjianyipeizhi != null){
        upjianyipeizhi = ObjectCopyUtils.copyProperties(jianyipeizhi,upjianyipeizhi,true);
      }
      return XfR.ok(jianyipeizhiServiceImpl.updateById(upjianyipeizhi));
  }

  /**
   * 通过id删除简易配置
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/jianyipeizhis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(jianyipeizhiServiceImpl.removeById(id));
  }

  @PostMapping("/jianyipeizhis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "jianyipeizhi");
     params.put("request", condition);

     return XfR.ok(jianyipeizhiServiceImpl.querys(params));
  }

}
