package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Juhe0406;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IJuhe0406Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * juhe0406前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Juhe0406Controller {

  @Autowired
  private IJuhe0406Service juhe0406ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param juhe0406 juhe0406
   * @return
   */
  @GetMapping("/juhe0406s" )
  public XfR getJuhe0406s(XfPage page, Juhe0406 juhe0406) {
    return XfR.ok(juhe0406ServiceImpl.page(page, Wrappers.query(juhe0406)));
  }

  /**
   * 通过id查询juhe0406
   * @param  id
   * @return XfR
   */
  @GetMapping("/juhe0406s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(juhe0406ServiceImpl.getById(id));
  }

  /**
   * 新增juhe0406
   * @param juhe0406 juhe0406
   * @return XfR
   */
  @PostMapping("/juhe0406s")
  public XfR save(@RequestBody Juhe0406 juhe0406) {
     return XfR.ok(juhe0406ServiceImpl.save(juhe0406));
  }

  /**
   * 修改-传入修改后的全部数据juhe0406
   * @param juhe0406 juhe0406
   * @return XfR
   */
  @PutMapping("/juhe0406s/{id}")
  public XfR putUpdate(@RequestBody Juhe0406 juhe0406,@PathVariable Long id) {
      juhe0406.setId(id);
      return XfR.ok(juhe0406ServiceImpl.updateById(juhe0406));
  }

  /**
   * 修改-传入修改的数据juhe0406
   * @param juhe0406 juhe0406
   * @return XfR
   */
  @PatchMapping("/juhe0406s/{id}")
  public XfR patchUpdate(@RequestBody Juhe0406 juhe0406,@PathVariable Long id) {
      Juhe0406 upjuhe0406 = juhe0406ServiceImpl.getById(id);
      if(upjuhe0406 != null){
        upjuhe0406 = ObjectCopyUtils.copyProperties(juhe0406,upjuhe0406,true);
      }
      return XfR.ok(juhe0406ServiceImpl.updateById(upjuhe0406));
  }

  /**
   * 通过id删除juhe0406
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/juhe0406s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(juhe0406ServiceImpl.removeById(id));
  }

  @PostMapping("/juhe0406s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "juhe0406");
     params.put("request", condition);

     return XfR.ok(juhe0406ServiceImpl.querys(params));
  }

}
