package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Juhe0406jingt;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IJuhe0406jingtService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * juhe0406jingt前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Juhe0406jingtController {

  @Autowired
  private IJuhe0406jingtService juhe0406jingtServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param juhe0406jingt juhe0406jingt
   * @return
   */
  @GetMapping("/juhe0406jingts" )
  public XfR getJuhe0406jingts(XfPage page, Juhe0406jingt juhe0406jingt) {
    return XfR.ok(juhe0406jingtServiceImpl.page(page, Wrappers.query(juhe0406jingt)));
  }

  /**
   * 通过id查询juhe0406jingt
   * @param  id
   * @return XfR
   */
  @GetMapping("/juhe0406jingts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(juhe0406jingtServiceImpl.getById(id));
  }

  /**
   * 新增juhe0406jingt
   * @param juhe0406jingt juhe0406jingt
   * @return XfR
   */
  @PostMapping("/juhe0406jingts")
  public XfR save(@RequestBody Juhe0406jingt juhe0406jingt) {
     return XfR.ok(juhe0406jingtServiceImpl.save(juhe0406jingt));
  }

  /**
   * 修改-传入修改后的全部数据juhe0406jingt
   * @param juhe0406jingt juhe0406jingt
   * @return XfR
   */
  @PutMapping("/juhe0406jingts/{id}")
  public XfR putUpdate(@RequestBody Juhe0406jingt juhe0406jingt,@PathVariable Long id) {
      juhe0406jingt.setId(id);
      return XfR.ok(juhe0406jingtServiceImpl.updateById(juhe0406jingt));
  }

  /**
   * 修改-传入修改的数据juhe0406jingt
   * @param juhe0406jingt juhe0406jingt
   * @return XfR
   */
  @PatchMapping("/juhe0406jingts/{id}")
  public XfR patchUpdate(@RequestBody Juhe0406jingt juhe0406jingt,@PathVariable Long id) {
      Juhe0406jingt upjuhe0406jingt = juhe0406jingtServiceImpl.getById(id);
      if(upjuhe0406jingt != null){
        upjuhe0406jingt = ObjectCopyUtils.copyProperties(juhe0406jingt,upjuhe0406jingt,true);
      }
      return XfR.ok(juhe0406jingtServiceImpl.updateById(upjuhe0406jingt));
  }

  /**
   * 通过id删除juhe0406jingt
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/juhe0406jingts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(juhe0406jingtServiceImpl.removeById(id));
  }

  @PostMapping("/juhe0406jingts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "juhe0406jingt");
     params.put("request", condition);

     return XfR.ok(juhe0406jingtServiceImpl.querys(params));
  }

}
