package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Juheduxiang;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IJuheduxiangService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 聚合对象前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class JuheduxiangController {

  @Autowired
  private IJuheduxiangService juheduxiangServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param juheduxiang 聚合对象
   * @return
   */
  @GetMapping("/juheduxiangs" )
  public XfR getJuheduxiangs(XfPage page, Juheduxiang juheduxiang) {
    return XfR.ok(juheduxiangServiceImpl.page(page, Wrappers.query(juheduxiang)));
  }

  /**
   * 通过id查询聚合对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/juheduxiangs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(juheduxiangServiceImpl.getById(id));
  }

  /**
   * 新增聚合对象
   * @param juheduxiang 聚合对象
   * @return XfR
   */
  @PostMapping("/juheduxiangs")
  public XfR save(@RequestBody Juheduxiang juheduxiang) {
     return XfR.ok(juheduxiangServiceImpl.save(juheduxiang));
  }

  /**
   * 修改-传入修改后的全部数据聚合对象
   * @param juheduxiang 聚合对象
   * @return XfR
   */
  @PutMapping("/juheduxiangs/{id}")
  public XfR putUpdate(@RequestBody Juheduxiang juheduxiang,@PathVariable Long id) {
      juheduxiang.setId(id);
      return XfR.ok(juheduxiangServiceImpl.updateById(juheduxiang));
  }

  /**
   * 修改-传入修改的数据聚合对象
   * @param juheduxiang 聚合对象
   * @return XfR
   */
  @PatchMapping("/juheduxiangs/{id}")
  public XfR patchUpdate(@RequestBody Juheduxiang juheduxiang,@PathVariable Long id) {
      Juheduxiang upjuheduxiang = juheduxiangServiceImpl.getById(id);
      if(upjuheduxiang != null){
        upjuheduxiang = ObjectCopyUtils.copyProperties(juheduxiang,upjuheduxiang,true);
      }
      return XfR.ok(juheduxiangServiceImpl.updateById(upjuheduxiang));
  }

  /**
   * 通过id删除聚合对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/juheduxiangs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(juheduxiangServiceImpl.removeById(id));
  }

  @PostMapping("/juheduxiangs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "juheduxiang");
     params.put("request", condition);

     return XfR.ok(juheduxiangServiceImpl.querys(params));
  }

}
