package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Lookup0120;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ILookup0120Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * lookup0120前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Lookup0120Controller {

  @Autowired
  private ILookup0120Service lookup0120ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param lookup0120 lookup0120
   * @return
   */
  @GetMapping("/lookup0120s" )
  public XfR getLookup0120s(XfPage page, Lookup0120 lookup0120) {
    return XfR.ok(lookup0120ServiceImpl.page(page, Wrappers.query(lookup0120)));
  }

  /**
   * 通过id查询lookup0120
   * @param  id
   * @return XfR
   */
  @GetMapping("/lookup0120s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(lookup0120ServiceImpl.getById(id));
  }

  /**
   * 新增lookup0120
   * @param lookup0120 lookup0120
   * @return XfR
   */
  @PostMapping("/lookup0120s")
  public XfR save(@RequestBody Lookup0120 lookup0120) {
     return XfR.ok(lookup0120ServiceImpl.save(lookup0120));
  }

  /**
   * 修改-传入修改后的全部数据lookup0120
   * @param lookup0120 lookup0120
   * @return XfR
   */
  @PutMapping("/lookup0120s/{id}")
  public XfR putUpdate(@RequestBody Lookup0120 lookup0120,@PathVariable Long id) {
      lookup0120.setId(id);
      return XfR.ok(lookup0120ServiceImpl.updateById(lookup0120));
  }

  /**
   * 修改-传入修改的数据lookup0120
   * @param lookup0120 lookup0120
   * @return XfR
   */
  @PatchMapping("/lookup0120s/{id}")
  public XfR patchUpdate(@RequestBody Lookup0120 lookup0120,@PathVariable Long id) {
      Lookup0120 uplookup0120 = lookup0120ServiceImpl.getById(id);
      if(uplookup0120 != null){
        uplookup0120 = ObjectCopyUtils.copyProperties(lookup0120,uplookup0120,true);
      }
      return XfR.ok(lookup0120ServiceImpl.updateById(uplookup0120));
  }

  /**
   * 通过id删除lookup0120
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/lookup0120s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(lookup0120ServiceImpl.removeById(id));
  }

  @PostMapping("/lookup0120s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "lookup0120");
     params.put("request", condition);

     return XfR.ok(lookup0120ServiceImpl.querys(params));
  }

}
