package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Lookup02406;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ILookup02406Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * lookup02406前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Lookup02406Controller {

  @Autowired
  private ILookup02406Service lookup02406ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param lookup02406 lookup02406
   * @return
   */
  @GetMapping("/lookup02406s" )
  public XfR getLookup02406s(XfPage page, Lookup02406 lookup02406) {
    return XfR.ok(lookup02406ServiceImpl.page(page, Wrappers.query(lookup02406)));
  }

  /**
   * 通过id查询lookup02406
   * @param  id
   * @return XfR
   */
  @GetMapping("/lookup02406s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(lookup02406ServiceImpl.getById(id));
  }

  /**
   * 新增lookup02406
   * @param lookup02406 lookup02406
   * @return XfR
   */
  @PostMapping("/lookup02406s")
  public XfR save(@RequestBody Lookup02406 lookup02406) {
     return XfR.ok(lookup02406ServiceImpl.save(lookup02406));
  }

  /**
   * 修改-传入修改后的全部数据lookup02406
   * @param lookup02406 lookup02406
   * @return XfR
   */
  @PutMapping("/lookup02406s/{id}")
  public XfR putUpdate(@RequestBody Lookup02406 lookup02406,@PathVariable Long id) {
      lookup02406.setId(id);
      return XfR.ok(lookup02406ServiceImpl.updateById(lookup02406));
  }

  /**
   * 修改-传入修改的数据lookup02406
   * @param lookup02406 lookup02406
   * @return XfR
   */
  @PatchMapping("/lookup02406s/{id}")
  public XfR patchUpdate(@RequestBody Lookup02406 lookup02406,@PathVariable Long id) {
      Lookup02406 uplookup02406 = lookup02406ServiceImpl.getById(id);
      if(uplookup02406 != null){
        uplookup02406 = ObjectCopyUtils.copyProperties(lookup02406,uplookup02406,true);
      }
      return XfR.ok(lookup02406ServiceImpl.updateById(uplookup02406));
  }

  /**
   * 通过id删除lookup02406
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/lookup02406s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(lookup02406ServiceImpl.removeById(id));
  }

  @PostMapping("/lookup02406s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "lookup02406");
     params.put("request", condition);

     return XfR.ok(lookup02406ServiceImpl.querys(params));
  }

}
