package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Lookup02406jingt;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ILookup02406jingtService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * lookup02406jingt前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Lookup02406jingtController {

  @Autowired
  private ILookup02406jingtService lookup02406jingtServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param lookup02406jingt lookup02406jingt
   * @return
   */
  @GetMapping("/lookup02406jingts" )
  public XfR getLookup02406jingts(XfPage page, Lookup02406jingt lookup02406jingt) {
    return XfR.ok(lookup02406jingtServiceImpl.page(page, Wrappers.query(lookup02406jingt)));
  }

  /**
   * 通过id查询lookup02406jingt
   * @param  id
   * @return XfR
   */
  @GetMapping("/lookup02406jingts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(lookup02406jingtServiceImpl.getById(id));
  }

  /**
   * 新增lookup02406jingt
   * @param lookup02406jingt lookup02406jingt
   * @return XfR
   */
  @PostMapping("/lookup02406jingts")
  public XfR save(@RequestBody Lookup02406jingt lookup02406jingt) {
     return XfR.ok(lookup02406jingtServiceImpl.save(lookup02406jingt));
  }

  /**
   * 修改-传入修改后的全部数据lookup02406jingt
   * @param lookup02406jingt lookup02406jingt
   * @return XfR
   */
  @PutMapping("/lookup02406jingts/{id}")
  public XfR putUpdate(@RequestBody Lookup02406jingt lookup02406jingt,@PathVariable Long id) {
      lookup02406jingt.setId(id);
      return XfR.ok(lookup02406jingtServiceImpl.updateById(lookup02406jingt));
  }

  /**
   * 修改-传入修改的数据lookup02406jingt
   * @param lookup02406jingt lookup02406jingt
   * @return XfR
   */
  @PatchMapping("/lookup02406jingts/{id}")
  public XfR patchUpdate(@RequestBody Lookup02406jingt lookup02406jingt,@PathVariable Long id) {
      Lookup02406jingt uplookup02406jingt = lookup02406jingtServiceImpl.getById(id);
      if(uplookup02406jingt != null){
        uplookup02406jingt = ObjectCopyUtils.copyProperties(lookup02406jingt,uplookup02406jingt,true);
      }
      return XfR.ok(lookup02406jingtServiceImpl.updateById(uplookup02406jingt));
  }

  /**
   * 通过id删除lookup02406jingt
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/lookup02406jingts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(lookup02406jingtServiceImpl.removeById(id));
  }

  @PostMapping("/lookup02406jingts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "lookup02406jingt");
     params.put("request", condition);

     return XfR.ok(lookup02406jingtServiceImpl.querys(params));
  }

}
