package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Lookup041501;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ILookup041501Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * lookup041501前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Lookup041501Controller {

  @Autowired
  private ILookup041501Service lookup041501ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param lookup041501 lookup041501
   * @return
   */
  @GetMapping("/lookup041501s" )
  public XfR getLookup041501s(XfPage page, Lookup041501 lookup041501) {
    return XfR.ok(lookup041501ServiceImpl.page(page, Wrappers.query(lookup041501)));
  }

  /**
   * 通过id查询lookup041501
   * @param  id
   * @return XfR
   */
  @GetMapping("/lookup041501s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(lookup041501ServiceImpl.getById(id));
  }

  /**
   * 新增lookup041501
   * @param lookup041501 lookup041501
   * @return XfR
   */
  @PostMapping("/lookup041501s")
  public XfR save(@RequestBody Lookup041501 lookup041501) {
     return XfR.ok(lookup041501ServiceImpl.save(lookup041501));
  }

  /**
   * 修改-传入修改后的全部数据lookup041501
   * @param lookup041501 lookup041501
   * @return XfR
   */
  @PutMapping("/lookup041501s/{id}")
  public XfR putUpdate(@RequestBody Lookup041501 lookup041501,@PathVariable Long id) {
      lookup041501.setId(id);
      return XfR.ok(lookup041501ServiceImpl.updateById(lookup041501));
  }

  /**
   * 修改-传入修改的数据lookup041501
   * @param lookup041501 lookup041501
   * @return XfR
   */
  @PatchMapping("/lookup041501s/{id}")
  public XfR patchUpdate(@RequestBody Lookup041501 lookup041501,@PathVariable Long id) {
      Lookup041501 uplookup041501 = lookup041501ServiceImpl.getById(id);
      if(uplookup041501 != null){
        uplookup041501 = ObjectCopyUtils.copyProperties(lookup041501,uplookup041501,true);
      }
      return XfR.ok(lookup041501ServiceImpl.updateById(uplookup041501));
  }

  /**
   * 通过id删除lookup041501
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/lookup041501s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(lookup041501ServiceImpl.removeById(id));
  }

  @PostMapping("/lookup041501s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "lookup041501");
     params.put("request", condition);

     return XfR.ok(lookup041501ServiceImpl.querys(params));
  }

}
