package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Lookup041502;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ILookup041502Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * lookup041502前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Lookup041502Controller {

  @Autowired
  private ILookup041502Service lookup041502ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param lookup041502 lookup041502
   * @return
   */
  @GetMapping("/lookup041502s" )
  public XfR getLookup041502s(XfPage page, Lookup041502 lookup041502) {
    return XfR.ok(lookup041502ServiceImpl.page(page, Wrappers.query(lookup041502)));
  }

  /**
   * 通过id查询lookup041502
   * @param  id
   * @return XfR
   */
  @GetMapping("/lookup041502s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(lookup041502ServiceImpl.getById(id));
  }

  /**
   * 新增lookup041502
   * @param lookup041502 lookup041502
   * @return XfR
   */
  @PostMapping("/lookup041502s")
  public XfR save(@RequestBody Lookup041502 lookup041502) {
     return XfR.ok(lookup041502ServiceImpl.save(lookup041502));
  }

  /**
   * 修改-传入修改后的全部数据lookup041502
   * @param lookup041502 lookup041502
   * @return XfR
   */
  @PutMapping("/lookup041502s/{id}")
  public XfR putUpdate(@RequestBody Lookup041502 lookup041502,@PathVariable Long id) {
      lookup041502.setId(id);
      return XfR.ok(lookup041502ServiceImpl.updateById(lookup041502));
  }

  /**
   * 修改-传入修改的数据lookup041502
   * @param lookup041502 lookup041502
   * @return XfR
   */
  @PatchMapping("/lookup041502s/{id}")
  public XfR patchUpdate(@RequestBody Lookup041502 lookup041502,@PathVariable Long id) {
      Lookup041502 uplookup041502 = lookup041502ServiceImpl.getById(id);
      if(uplookup041502 != null){
        uplookup041502 = ObjectCopyUtils.copyProperties(lookup041502,uplookup041502,true);
      }
      return XfR.ok(lookup041502ServiceImpl.updateById(uplookup041502));
  }

  /**
   * 通过id删除lookup041502
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/lookup041502s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(lookup041502ServiceImpl.removeById(id));
  }

  @PostMapping("/lookup041502s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "lookup041502");
     params.put("request", condition);

     return XfR.ok(lookup041502ServiceImpl.querys(params));
  }

}
