package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Lookup1227;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ILookup1227Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 测试lookup对象下载前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Lookup1227Controller {

  @Autowired
  private ILookup1227Service lookup1227ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param lookup1227 测试lookup对象下载
   * @return
   */
  @GetMapping("/lookup1227s" )
  public XfR getLookup1227s(XfPage page, Lookup1227 lookup1227) {
    return XfR.ok(lookup1227ServiceImpl.page(page, Wrappers.query(lookup1227)));
  }

  /**
   * 通过id查询测试lookup对象下载
   * @param  id
   * @return XfR
   */
  @GetMapping("/lookup1227s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(lookup1227ServiceImpl.getById(id));
  }

  /**
   * 新增测试lookup对象下载
   * @param lookup1227 测试lookup对象下载
   * @return XfR
   */
  @PostMapping("/lookup1227s")
  public XfR save(@RequestBody Lookup1227 lookup1227) {
     return XfR.ok(lookup1227ServiceImpl.save(lookup1227));
  }

  /**
   * 修改-传入修改后的全部数据测试lookup对象下载
   * @param lookup1227 测试lookup对象下载
   * @return XfR
   */
  @PutMapping("/lookup1227s/{id}")
  public XfR putUpdate(@RequestBody Lookup1227 lookup1227,@PathVariable Long id) {
      lookup1227.setId(id);
      return XfR.ok(lookup1227ServiceImpl.updateById(lookup1227));
  }

  /**
   * 修改-传入修改的数据测试lookup对象下载
   * @param lookup1227 测试lookup对象下载
   * @return XfR
   */
  @PatchMapping("/lookup1227s/{id}")
  public XfR patchUpdate(@RequestBody Lookup1227 lookup1227,@PathVariable Long id) {
      Lookup1227 uplookup1227 = lookup1227ServiceImpl.getById(id);
      if(uplookup1227 != null){
        uplookup1227 = ObjectCopyUtils.copyProperties(lookup1227,uplookup1227,true);
      }
      return XfR.ok(lookup1227ServiceImpl.updateById(uplookup1227));
  }

  /**
   * 通过id删除测试lookup对象下载
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/lookup1227s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(lookup1227ServiceImpl.removeById(id));
  }

  @PostMapping("/lookup1227s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "lookup1227");
     params.put("request", condition);

     return XfR.ok(lookup1227ServiceImpl.querys(params));
  }

}
