package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Lookup1230;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ILookup1230Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * lookup对象1230前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Lookup1230Controller {

  @Autowired
  private ILookup1230Service lookup1230ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param lookup1230 lookup对象1230
   * @return
   */
  @GetMapping("/lookup1230s" )
  public XfR getLookup1230s(XfPage page, Lookup1230 lookup1230) {
    return XfR.ok(lookup1230ServiceImpl.page(page, Wrappers.query(lookup1230)));
  }

  /**
   * 通过id查询lookup对象1230
   * @param  id
   * @return XfR
   */
  @GetMapping("/lookup1230s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(lookup1230ServiceImpl.getById(id));
  }

  /**
   * 新增lookup对象1230
   * @param lookup1230 lookup对象1230
   * @return XfR
   */
  @PostMapping("/lookup1230s")
  public XfR save(@RequestBody Lookup1230 lookup1230) {
     return XfR.ok(lookup1230ServiceImpl.save(lookup1230));
  }

  /**
   * 修改-传入修改后的全部数据lookup对象1230
   * @param lookup1230 lookup对象1230
   * @return XfR
   */
  @PutMapping("/lookup1230s/{id}")
  public XfR putUpdate(@RequestBody Lookup1230 lookup1230,@PathVariable Long id) {
      lookup1230.setId(id);
      return XfR.ok(lookup1230ServiceImpl.updateById(lookup1230));
  }

  /**
   * 修改-传入修改的数据lookup对象1230
   * @param lookup1230 lookup对象1230
   * @return XfR
   */
  @PatchMapping("/lookup1230s/{id}")
  public XfR patchUpdate(@RequestBody Lookup1230 lookup1230,@PathVariable Long id) {
      Lookup1230 uplookup1230 = lookup1230ServiceImpl.getById(id);
      if(uplookup1230 != null){
        uplookup1230 = ObjectCopyUtils.copyProperties(lookup1230,uplookup1230,true);
      }
      return XfR.ok(lookup1230ServiceImpl.updateById(uplookup1230));
  }

  /**
   * 通过id删除lookup对象1230
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/lookup1230s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(lookup1230ServiceImpl.removeById(id));
  }

  @PostMapping("/lookup1230s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "lookup1230");
     params.put("request", condition);

     return XfR.ok(lookup1230ServiceImpl.querys(params));
  }

}
