package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Lookup2;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ILookup2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * lookup2前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Lookup2Controller {

  @Autowired
  private ILookup2Service lookup2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param lookup2 lookup2
   * @return
   */
  @GetMapping("/lookup2s" )
  public XfR getLookup2s(XfPage page, Lookup2 lookup2) {
    return XfR.ok(lookup2ServiceImpl.page(page, Wrappers.query(lookup2)));
  }

  /**
   * 通过id查询lookup2
   * @param  id
   * @return XfR
   */
  @GetMapping("/lookup2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(lookup2ServiceImpl.getById(id));
  }

  /**
   * 新增lookup2
   * @param lookup2 lookup2
   * @return XfR
   */
  @PostMapping("/lookup2s")
  public XfR save(@RequestBody Lookup2 lookup2) {
     return XfR.ok(lookup2ServiceImpl.save(lookup2));
  }

  /**
   * 修改-传入修改后的全部数据lookup2
   * @param lookup2 lookup2
   * @return XfR
   */
  @PutMapping("/lookup2s/{id}")
  public XfR putUpdate(@RequestBody Lookup2 lookup2,@PathVariable Long id) {
      lookup2.setId(id);
      return XfR.ok(lookup2ServiceImpl.updateById(lookup2));
  }

  /**
   * 修改-传入修改的数据lookup2
   * @param lookup2 lookup2
   * @return XfR
   */
  @PatchMapping("/lookup2s/{id}")
  public XfR patchUpdate(@RequestBody Lookup2 lookup2,@PathVariable Long id) {
      Lookup2 uplookup2 = lookup2ServiceImpl.getById(id);
      if(uplookup2 != null){
        uplookup2 = ObjectCopyUtils.copyProperties(lookup2,uplookup2,true);
      }
      return XfR.ok(lookup2ServiceImpl.updateById(uplookup2));
  }

  /**
   * 通过id删除lookup2
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/lookup2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(lookup2ServiceImpl.removeById(id));
  }

  @PostMapping("/lookup2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "lookup2");
     params.put("request", condition);

     return XfR.ok(lookup2ServiceImpl.querys(params));
  }

}
