package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Lookup;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ILookupService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * lookup前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class LookupController {

  @Autowired
  private ILookupService lookupServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param lookup lookup
   * @return
   */
  @GetMapping("/lookups" )
  public XfR getLookups(XfPage page, Lookup lookup) {
    return XfR.ok(lookupServiceImpl.page(page, Wrappers.query(lookup)));
  }

  /**
   * 通过id查询lookup
   * @param  id
   * @return XfR
   */
  @GetMapping("/lookups/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(lookupServiceImpl.getById(id));
  }

  /**
   * 新增lookup
   * @param lookup lookup
   * @return XfR
   */
  @PostMapping("/lookups")
  public XfR save(@RequestBody Lookup lookup) {
     return XfR.ok(lookupServiceImpl.save(lookup));
  }

  /**
   * 修改-传入修改后的全部数据lookup
   * @param lookup lookup
   * @return XfR
   */
  @PutMapping("/lookups/{id}")
  public XfR putUpdate(@RequestBody Lookup lookup,@PathVariable Long id) {
      lookup.setId(id);
      return XfR.ok(lookupServiceImpl.updateById(lookup));
  }

  /**
   * 修改-传入修改的数据lookup
   * @param lookup lookup
   * @return XfR
   */
  @PatchMapping("/lookups/{id}")
  public XfR patchUpdate(@RequestBody Lookup lookup,@PathVariable Long id) {
      Lookup uplookup = lookupServiceImpl.getById(id);
      if(uplookup != null){
        uplookup = ObjectCopyUtils.copyProperties(lookup,uplookup,true);
      }
      return XfR.ok(lookupServiceImpl.updateById(uplookup));
  }

  /**
   * 通过id删除lookup
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/lookups/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(lookupServiceImpl.removeById(id));
  }

  @PostMapping("/lookups/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "lookup");
     params.put("request", condition);

     return XfR.ok(lookupServiceImpl.querys(params));
  }

}
