package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Mingxiobject;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IMingxiobjectService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 明细1230前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class MingxiobjectController {

  @Autowired
  private IMingxiobjectService mingxiobjectServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param mingxiobject 明细1230
   * @return
   */
  @GetMapping("/mingxiobjects" )
  public XfR getMingxiobjects(XfPage page, Mingxiobject mingxiobject) {
    return XfR.ok(mingxiobjectServiceImpl.page(page, Wrappers.query(mingxiobject)));
  }

  /**
   * 通过id查询明细1230
   * @param  id
   * @return XfR
   */
  @GetMapping("/mingxiobjects/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(mingxiobjectServiceImpl.getById(id));
  }

  /**
   * 新增明细1230
   * @param mingxiobject 明细1230
   * @return XfR
   */
  @PostMapping("/mingxiobjects")
  public XfR save(@RequestBody Mingxiobject mingxiobject) {
     return XfR.ok(mingxiobjectServiceImpl.save(mingxiobject));
  }

  /**
   * 修改-传入修改后的全部数据明细1230
   * @param mingxiobject 明细1230
   * @return XfR
   */
  @PutMapping("/mingxiobjects/{id}")
  public XfR putUpdate(@RequestBody Mingxiobject mingxiobject,@PathVariable Long id) {
      mingxiobject.setId(id);
      return XfR.ok(mingxiobjectServiceImpl.updateById(mingxiobject));
  }

  /**
   * 修改-传入修改的数据明细1230
   * @param mingxiobject 明细1230
   * @return XfR
   */
  @PatchMapping("/mingxiobjects/{id}")
  public XfR patchUpdate(@RequestBody Mingxiobject mingxiobject,@PathVariable Long id) {
      Mingxiobject upmingxiobject = mingxiobjectServiceImpl.getById(id);
      if(upmingxiobject != null){
        upmingxiobject = ObjectCopyUtils.copyProperties(mingxiobject,upmingxiobject,true);
      }
      return XfR.ok(mingxiobjectServiceImpl.updateById(upmingxiobject));
  }

  /**
   * 通过id删除明细1230
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/mingxiobjects/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(mingxiobjectServiceImpl.removeById(id));
  }

  @PostMapping("/mingxiobjects/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "mingxiobject");
     params.put("request", condition);

     return XfR.ok(mingxiobjectServiceImpl.querys(params));
  }

}
