package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Oneclass;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOneclassService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * oneclass前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class OneclassController {

  @Autowired
  private IOneclassService oneclassServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param oneclass oneclass
   * @return
   */
  @GetMapping("/oneclasss" )
  public XfR getOneclasss(XfPage page, Oneclass oneclass) {
    return XfR.ok(oneclassServiceImpl.page(page, Wrappers.query(oneclass)));
  }

  /**
   * 通过id查询oneclass
   * @param  id
   * @return XfR
   */
  @GetMapping("/oneclasss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(oneclassServiceImpl.getById(id));
  }

  /**
   * 新增oneclass
   * @param oneclass oneclass
   * @return XfR
   */
  @PostMapping("/oneclasss")
  public XfR save(@RequestBody Oneclass oneclass) {
     return XfR.ok(oneclassServiceImpl.save(oneclass));
  }

  /**
   * 修改-传入修改后的全部数据oneclass
   * @param oneclass oneclass
   * @return XfR
   */
  @PutMapping("/oneclasss/{id}")
  public XfR putUpdate(@RequestBody Oneclass oneclass,@PathVariable Long id) {
      oneclass.setId(id);
      return XfR.ok(oneclassServiceImpl.updateById(oneclass));
  }

  /**
   * 修改-传入修改的数据oneclass
   * @param oneclass oneclass
   * @return XfR
   */
  @PatchMapping("/oneclasss/{id}")
  public XfR patchUpdate(@RequestBody Oneclass oneclass,@PathVariable Long id) {
      Oneclass uponeclass = oneclassServiceImpl.getById(id);
      if(uponeclass != null){
        uponeclass = ObjectCopyUtils.copyProperties(oneclass,uponeclass,true);
      }
      return XfR.ok(oneclassServiceImpl.updateById(uponeclass));
  }

  /**
   * 通过id删除oneclass
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/oneclasss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(oneclassServiceImpl.removeById(id));
  }

  @PostMapping("/oneclasss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oneclass");
     params.put("request", condition);

     return XfR.ok(oneclassServiceImpl.querys(params));
  }

}
