package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.OrderItems;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrderItemsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * orderItems前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class OrderItemsController {

  @Autowired
  private IOrderItemsService orderItemsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderItems orderItems
   * @return
   */
  @GetMapping("/orderitemss" )
  public XfR getOrderItemss(XfPage page, OrderItems orderItems) {
    return XfR.ok(orderItemsServiceImpl.page(page, Wrappers.query(orderItems)));
  }

  /**
   * 通过id查询orderItems
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderitemss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderItemsServiceImpl.getById(id));
  }

  /**
   * 新增orderItems
   * @param orderItems orderItems
   * @return XfR
   */
  @PostMapping("/orderitemss")
  public XfR save(@RequestBody OrderItems orderItems) {
     return XfR.ok(orderItemsServiceImpl.save(orderItems));
  }

  /**
   * 修改-传入修改后的全部数据orderItems
   * @param orderItems orderItems
   * @return XfR
   */
  @PutMapping("/orderitemss/{id}")
  public XfR putUpdate(@RequestBody OrderItems orderItems,@PathVariable Long id) {
      orderItems.setId(id);
      return XfR.ok(orderItemsServiceImpl.updateById(orderItems));
  }

  /**
   * 修改-传入修改的数据orderItems
   * @param orderItems orderItems
   * @return XfR
   */
  @PatchMapping("/orderitemss/{id}")
  public XfR patchUpdate(@RequestBody OrderItems orderItems,@PathVariable Long id) {
      OrderItems uporderItems = orderItemsServiceImpl.getById(id);
      if(uporderItems != null){
        uporderItems = ObjectCopyUtils.copyProperties(orderItems,uporderItems,true);
      }
      return XfR.ok(orderItemsServiceImpl.updateById(uporderItems));
  }

  /**
   * 通过id删除orderItems
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderitemss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderItemsServiceImpl.removeById(id));
  }

  @PostMapping("/orderitemss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_items");
     params.put("request", condition);

     return XfR.ok(orderItemsServiceImpl.querys(params));
  }

}
