package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Orderitems10;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrderitems10Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * orderitems10前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Orderitems10Controller {

  @Autowired
  private IOrderitems10Service orderitems10ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderitems10 orderitems10
   * @return
   */
  @GetMapping("/orderitems10s" )
  public XfR getOrderitems10s(XfPage page, Orderitems10 orderitems10) {
    return XfR.ok(orderitems10ServiceImpl.page(page, Wrappers.query(orderitems10)));
  }

  /**
   * 通过id查询orderitems10
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderitems10s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderitems10ServiceImpl.getById(id));
  }

  /**
   * 新增orderitems10
   * @param orderitems10 orderitems10
   * @return XfR
   */
  @PostMapping("/orderitems10s")
  public XfR save(@RequestBody Orderitems10 orderitems10) {
     return XfR.ok(orderitems10ServiceImpl.save(orderitems10));
  }

  /**
   * 修改-传入修改后的全部数据orderitems10
   * @param orderitems10 orderitems10
   * @return XfR
   */
  @PutMapping("/orderitems10s/{id}")
  public XfR putUpdate(@RequestBody Orderitems10 orderitems10,@PathVariable Long id) {
      orderitems10.setId(id);
      return XfR.ok(orderitems10ServiceImpl.updateById(orderitems10));
  }

  /**
   * 修改-传入修改的数据orderitems10
   * @param orderitems10 orderitems10
   * @return XfR
   */
  @PatchMapping("/orderitems10s/{id}")
  public XfR patchUpdate(@RequestBody Orderitems10 orderitems10,@PathVariable Long id) {
      Orderitems10 uporderitems10 = orderitems10ServiceImpl.getById(id);
      if(uporderitems10 != null){
        uporderitems10 = ObjectCopyUtils.copyProperties(orderitems10,uporderitems10,true);
      }
      return XfR.ok(orderitems10ServiceImpl.updateById(uporderitems10));
  }

  /**
   * 通过id删除orderitems10
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderitems10s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderitems10ServiceImpl.removeById(id));
  }

  @PostMapping("/orderitems10s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "orderitems10");
     params.put("request", condition);

     return XfR.ok(orderitems10ServiceImpl.querys(params));
  }

}
