package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Orderitems11;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrderitems11Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * orderitems11前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Orderitems11Controller {

  @Autowired
  private IOrderitems11Service orderitems11ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderitems11 orderitems11
   * @return
   */
  @GetMapping("/orderitems11s" )
  public XfR getOrderitems11s(XfPage page, Orderitems11 orderitems11) {
    return XfR.ok(orderitems11ServiceImpl.page(page, Wrappers.query(orderitems11)));
  }

  /**
   * 通过id查询orderitems11
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderitems11s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderitems11ServiceImpl.getById(id));
  }

  /**
   * 新增orderitems11
   * @param orderitems11 orderitems11
   * @return XfR
   */
  @PostMapping("/orderitems11s")
  public XfR save(@RequestBody Orderitems11 orderitems11) {
     return XfR.ok(orderitems11ServiceImpl.save(orderitems11));
  }

  /**
   * 修改-传入修改后的全部数据orderitems11
   * @param orderitems11 orderitems11
   * @return XfR
   */
  @PutMapping("/orderitems11s/{id}")
  public XfR putUpdate(@RequestBody Orderitems11 orderitems11,@PathVariable Long id) {
      orderitems11.setId(id);
      return XfR.ok(orderitems11ServiceImpl.updateById(orderitems11));
  }

  /**
   * 修改-传入修改的数据orderitems11
   * @param orderitems11 orderitems11
   * @return XfR
   */
  @PatchMapping("/orderitems11s/{id}")
  public XfR patchUpdate(@RequestBody Orderitems11 orderitems11,@PathVariable Long id) {
      Orderitems11 uporderitems11 = orderitems11ServiceImpl.getById(id);
      if(uporderitems11 != null){
        uporderitems11 = ObjectCopyUtils.copyProperties(orderitems11,uporderitems11,true);
      }
      return XfR.ok(orderitems11ServiceImpl.updateById(uporderitems11));
  }

  /**
   * 通过id删除orderitems11
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderitems11s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderitems11ServiceImpl.removeById(id));
  }

  @PostMapping("/orderitems11s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "orderitems11");
     params.put("request", condition);

     return XfR.ok(orderitems11ServiceImpl.querys(params));
  }

}
