package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Orderitems12;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrderitems12Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * orderitems12前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Orderitems12Controller {

  @Autowired
  private IOrderitems12Service orderitems12ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderitems12 orderitems12
   * @return
   */
  @GetMapping("/orderitems12s" )
  public XfR getOrderitems12s(XfPage page, Orderitems12 orderitems12) {
    return XfR.ok(orderitems12ServiceImpl.page(page, Wrappers.query(orderitems12)));
  }

  /**
   * 通过id查询orderitems12
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderitems12s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderitems12ServiceImpl.getById(id));
  }

  /**
   * 新增orderitems12
   * @param orderitems12 orderitems12
   * @return XfR
   */
  @PostMapping("/orderitems12s")
  public XfR save(@RequestBody Orderitems12 orderitems12) {
     return XfR.ok(orderitems12ServiceImpl.save(orderitems12));
  }

  /**
   * 修改-传入修改后的全部数据orderitems12
   * @param orderitems12 orderitems12
   * @return XfR
   */
  @PutMapping("/orderitems12s/{id}")
  public XfR putUpdate(@RequestBody Orderitems12 orderitems12,@PathVariable Long id) {
      orderitems12.setId(id);
      return XfR.ok(orderitems12ServiceImpl.updateById(orderitems12));
  }

  /**
   * 修改-传入修改的数据orderitems12
   * @param orderitems12 orderitems12
   * @return XfR
   */
  @PatchMapping("/orderitems12s/{id}")
  public XfR patchUpdate(@RequestBody Orderitems12 orderitems12,@PathVariable Long id) {
      Orderitems12 uporderitems12 = orderitems12ServiceImpl.getById(id);
      if(uporderitems12 != null){
        uporderitems12 = ObjectCopyUtils.copyProperties(orderitems12,uporderitems12,true);
      }
      return XfR.ok(orderitems12ServiceImpl.updateById(uporderitems12));
  }

  /**
   * 通过id删除orderitems12
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderitems12s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderitems12ServiceImpl.removeById(id));
  }

  @PostMapping("/orderitems12s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "orderitems12");
     params.put("request", condition);

     return XfR.ok(orderitems12ServiceImpl.querys(params));
  }

}
