package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Orderitems13;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrderitems13Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * orderitems13前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Orderitems13Controller {

  @Autowired
  private IOrderitems13Service orderitems13ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderitems13 orderitems13
   * @return
   */
  @GetMapping("/orderitems13s" )
  public XfR getOrderitems13s(XfPage page, Orderitems13 orderitems13) {
    return XfR.ok(orderitems13ServiceImpl.page(page, Wrappers.query(orderitems13)));
  }

  /**
   * 通过id查询orderitems13
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderitems13s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderitems13ServiceImpl.getById(id));
  }

  /**
   * 新增orderitems13
   * @param orderitems13 orderitems13
   * @return XfR
   */
  @PostMapping("/orderitems13s")
  public XfR save(@RequestBody Orderitems13 orderitems13) {
     return XfR.ok(orderitems13ServiceImpl.save(orderitems13));
  }

  /**
   * 修改-传入修改后的全部数据orderitems13
   * @param orderitems13 orderitems13
   * @return XfR
   */
  @PutMapping("/orderitems13s/{id}")
  public XfR putUpdate(@RequestBody Orderitems13 orderitems13,@PathVariable Long id) {
      orderitems13.setId(id);
      return XfR.ok(orderitems13ServiceImpl.updateById(orderitems13));
  }

  /**
   * 修改-传入修改的数据orderitems13
   * @param orderitems13 orderitems13
   * @return XfR
   */
  @PatchMapping("/orderitems13s/{id}")
  public XfR patchUpdate(@RequestBody Orderitems13 orderitems13,@PathVariable Long id) {
      Orderitems13 uporderitems13 = orderitems13ServiceImpl.getById(id);
      if(uporderitems13 != null){
        uporderitems13 = ObjectCopyUtils.copyProperties(orderitems13,uporderitems13,true);
      }
      return XfR.ok(orderitems13ServiceImpl.updateById(uporderitems13));
  }

  /**
   * 通过id删除orderitems13
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderitems13s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderitems13ServiceImpl.removeById(id));
  }

  @PostMapping("/orderitems13s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "orderitems13");
     params.put("request", condition);

     return XfR.ok(orderitems13ServiceImpl.querys(params));
  }

}
