package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Orderitems14;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrderitems14Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * orderitems14前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Orderitems14Controller {

  @Autowired
  private IOrderitems14Service orderitems14ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderitems14 orderitems14
   * @return
   */
  @GetMapping("/orderitems14s" )
  public XfR getOrderitems14s(XfPage page, Orderitems14 orderitems14) {
    return XfR.ok(orderitems14ServiceImpl.page(page, Wrappers.query(orderitems14)));
  }

  /**
   * 通过id查询orderitems14
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderitems14s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderitems14ServiceImpl.getById(id));
  }

  /**
   * 新增orderitems14
   * @param orderitems14 orderitems14
   * @return XfR
   */
  @PostMapping("/orderitems14s")
  public XfR save(@RequestBody Orderitems14 orderitems14) {
     return XfR.ok(orderitems14ServiceImpl.save(orderitems14));
  }

  /**
   * 修改-传入修改后的全部数据orderitems14
   * @param orderitems14 orderitems14
   * @return XfR
   */
  @PutMapping("/orderitems14s/{id}")
  public XfR putUpdate(@RequestBody Orderitems14 orderitems14,@PathVariable Long id) {
      orderitems14.setId(id);
      return XfR.ok(orderitems14ServiceImpl.updateById(orderitems14));
  }

  /**
   * 修改-传入修改的数据orderitems14
   * @param orderitems14 orderitems14
   * @return XfR
   */
  @PatchMapping("/orderitems14s/{id}")
  public XfR patchUpdate(@RequestBody Orderitems14 orderitems14,@PathVariable Long id) {
      Orderitems14 uporderitems14 = orderitems14ServiceImpl.getById(id);
      if(uporderitems14 != null){
        uporderitems14 = ObjectCopyUtils.copyProperties(orderitems14,uporderitems14,true);
      }
      return XfR.ok(orderitems14ServiceImpl.updateById(uporderitems14));
  }

  /**
   * 通过id删除orderitems14
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderitems14s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderitems14ServiceImpl.removeById(id));
  }

  @PostMapping("/orderitems14s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "orderitems14");
     params.put("request", condition);

     return XfR.ok(orderitems14ServiceImpl.querys(params));
  }

}
