package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Orderitems1;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrderitems1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * orderitems1前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Orderitems1Controller {

  @Autowired
  private IOrderitems1Service orderitems1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderitems1 orderitems1
   * @return
   */
  @GetMapping("/orderitems1s" )
  public XfR getOrderitems1s(XfPage page, Orderitems1 orderitems1) {
    return XfR.ok(orderitems1ServiceImpl.page(page, Wrappers.query(orderitems1)));
  }

  /**
   * 通过id查询orderitems1
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderitems1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderitems1ServiceImpl.getById(id));
  }

  /**
   * 新增orderitems1
   * @param orderitems1 orderitems1
   * @return XfR
   */
  @PostMapping("/orderitems1s")
  public XfR save(@RequestBody Orderitems1 orderitems1) {
     return XfR.ok(orderitems1ServiceImpl.save(orderitems1));
  }

  /**
   * 修改-传入修改后的全部数据orderitems1
   * @param orderitems1 orderitems1
   * @return XfR
   */
  @PutMapping("/orderitems1s/{id}")
  public XfR putUpdate(@RequestBody Orderitems1 orderitems1,@PathVariable Long id) {
      orderitems1.setId(id);
      return XfR.ok(orderitems1ServiceImpl.updateById(orderitems1));
  }

  /**
   * 修改-传入修改的数据orderitems1
   * @param orderitems1 orderitems1
   * @return XfR
   */
  @PatchMapping("/orderitems1s/{id}")
  public XfR patchUpdate(@RequestBody Orderitems1 orderitems1,@PathVariable Long id) {
      Orderitems1 uporderitems1 = orderitems1ServiceImpl.getById(id);
      if(uporderitems1 != null){
        uporderitems1 = ObjectCopyUtils.copyProperties(orderitems1,uporderitems1,true);
      }
      return XfR.ok(orderitems1ServiceImpl.updateById(uporderitems1));
  }

  /**
   * 通过id删除orderitems1
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderitems1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderitems1ServiceImpl.removeById(id));
  }

  @PostMapping("/orderitems1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "orderitems1");
     params.put("request", condition);

     return XfR.ok(orderitems1ServiceImpl.querys(params));
  }

}
