package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Orderitems2;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrderitems2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * orderitems2前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Orderitems2Controller {

  @Autowired
  private IOrderitems2Service orderitems2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderitems2 orderitems2
   * @return
   */
  @GetMapping("/orderitems2s" )
  public XfR getOrderitems2s(XfPage page, Orderitems2 orderitems2) {
    return XfR.ok(orderitems2ServiceImpl.page(page, Wrappers.query(orderitems2)));
  }

  /**
   * 通过id查询orderitems2
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderitems2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderitems2ServiceImpl.getById(id));
  }

  /**
   * 新增orderitems2
   * @param orderitems2 orderitems2
   * @return XfR
   */
  @PostMapping("/orderitems2s")
  public XfR save(@RequestBody Orderitems2 orderitems2) {
     return XfR.ok(orderitems2ServiceImpl.save(orderitems2));
  }

  /**
   * 修改-传入修改后的全部数据orderitems2
   * @param orderitems2 orderitems2
   * @return XfR
   */
  @PutMapping("/orderitems2s/{id}")
  public XfR putUpdate(@RequestBody Orderitems2 orderitems2,@PathVariable Long id) {
      orderitems2.setId(id);
      return XfR.ok(orderitems2ServiceImpl.updateById(orderitems2));
  }

  /**
   * 修改-传入修改的数据orderitems2
   * @param orderitems2 orderitems2
   * @return XfR
   */
  @PatchMapping("/orderitems2s/{id}")
  public XfR patchUpdate(@RequestBody Orderitems2 orderitems2,@PathVariable Long id) {
      Orderitems2 uporderitems2 = orderitems2ServiceImpl.getById(id);
      if(uporderitems2 != null){
        uporderitems2 = ObjectCopyUtils.copyProperties(orderitems2,uporderitems2,true);
      }
      return XfR.ok(orderitems2ServiceImpl.updateById(uporderitems2));
  }

  /**
   * 通过id删除orderitems2
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderitems2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderitems2ServiceImpl.removeById(id));
  }

  @PostMapping("/orderitems2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "orderitems2");
     params.put("request", condition);

     return XfR.ok(orderitems2ServiceImpl.querys(params));
  }

}
