package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Orderitems3;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrderitems3Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * orderitems3前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Orderitems3Controller {

  @Autowired
  private IOrderitems3Service orderitems3ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderitems3 orderitems3
   * @return
   */
  @GetMapping("/orderitems3s" )
  public XfR getOrderitems3s(XfPage page, Orderitems3 orderitems3) {
    return XfR.ok(orderitems3ServiceImpl.page(page, Wrappers.query(orderitems3)));
  }

  /**
   * 通过id查询orderitems3
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderitems3s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderitems3ServiceImpl.getById(id));
  }

  /**
   * 新增orderitems3
   * @param orderitems3 orderitems3
   * @return XfR
   */
  @PostMapping("/orderitems3s")
  public XfR save(@RequestBody Orderitems3 orderitems3) {
     return XfR.ok(orderitems3ServiceImpl.save(orderitems3));
  }

  /**
   * 修改-传入修改后的全部数据orderitems3
   * @param orderitems3 orderitems3
   * @return XfR
   */
  @PutMapping("/orderitems3s/{id}")
  public XfR putUpdate(@RequestBody Orderitems3 orderitems3,@PathVariable Long id) {
      orderitems3.setId(id);
      return XfR.ok(orderitems3ServiceImpl.updateById(orderitems3));
  }

  /**
   * 修改-传入修改的数据orderitems3
   * @param orderitems3 orderitems3
   * @return XfR
   */
  @PatchMapping("/orderitems3s/{id}")
  public XfR patchUpdate(@RequestBody Orderitems3 orderitems3,@PathVariable Long id) {
      Orderitems3 uporderitems3 = orderitems3ServiceImpl.getById(id);
      if(uporderitems3 != null){
        uporderitems3 = ObjectCopyUtils.copyProperties(orderitems3,uporderitems3,true);
      }
      return XfR.ok(orderitems3ServiceImpl.updateById(uporderitems3));
  }

  /**
   * 通过id删除orderitems3
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderitems3s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderitems3ServiceImpl.removeById(id));
  }

  @PostMapping("/orderitems3s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "orderitems3");
     params.put("request", condition);

     return XfR.ok(orderitems3ServiceImpl.querys(params));
  }

}
