package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Orderitems4;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrderitems4Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * orderitems4前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Orderitems4Controller {

  @Autowired
  private IOrderitems4Service orderitems4ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderitems4 orderitems4
   * @return
   */
  @GetMapping("/orderitems4s" )
  public XfR getOrderitems4s(XfPage page, Orderitems4 orderitems4) {
    return XfR.ok(orderitems4ServiceImpl.page(page, Wrappers.query(orderitems4)));
  }

  /**
   * 通过id查询orderitems4
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderitems4s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderitems4ServiceImpl.getById(id));
  }

  /**
   * 新增orderitems4
   * @param orderitems4 orderitems4
   * @return XfR
   */
  @PostMapping("/orderitems4s")
  public XfR save(@RequestBody Orderitems4 orderitems4) {
     return XfR.ok(orderitems4ServiceImpl.save(orderitems4));
  }

  /**
   * 修改-传入修改后的全部数据orderitems4
   * @param orderitems4 orderitems4
   * @return XfR
   */
  @PutMapping("/orderitems4s/{id}")
  public XfR putUpdate(@RequestBody Orderitems4 orderitems4,@PathVariable Long id) {
      orderitems4.setId(id);
      return XfR.ok(orderitems4ServiceImpl.updateById(orderitems4));
  }

  /**
   * 修改-传入修改的数据orderitems4
   * @param orderitems4 orderitems4
   * @return XfR
   */
  @PatchMapping("/orderitems4s/{id}")
  public XfR patchUpdate(@RequestBody Orderitems4 orderitems4,@PathVariable Long id) {
      Orderitems4 uporderitems4 = orderitems4ServiceImpl.getById(id);
      if(uporderitems4 != null){
        uporderitems4 = ObjectCopyUtils.copyProperties(orderitems4,uporderitems4,true);
      }
      return XfR.ok(orderitems4ServiceImpl.updateById(uporderitems4));
  }

  /**
   * 通过id删除orderitems4
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderitems4s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderitems4ServiceImpl.removeById(id));
  }

  @PostMapping("/orderitems4s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "orderitems4");
     params.put("request", condition);

     return XfR.ok(orderitems4ServiceImpl.querys(params));
  }

}
