package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Orderitems5;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrderitems5Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * orderitems5前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Orderitems5Controller {

  @Autowired
  private IOrderitems5Service orderitems5ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderitems5 orderitems5
   * @return
   */
  @GetMapping("/orderitems5s" )
  public XfR getOrderitems5s(XfPage page, Orderitems5 orderitems5) {
    return XfR.ok(orderitems5ServiceImpl.page(page, Wrappers.query(orderitems5)));
  }

  /**
   * 通过id查询orderitems5
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderitems5s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderitems5ServiceImpl.getById(id));
  }

  /**
   * 新增orderitems5
   * @param orderitems5 orderitems5
   * @return XfR
   */
  @PostMapping("/orderitems5s")
  public XfR save(@RequestBody Orderitems5 orderitems5) {
     return XfR.ok(orderitems5ServiceImpl.save(orderitems5));
  }

  /**
   * 修改-传入修改后的全部数据orderitems5
   * @param orderitems5 orderitems5
   * @return XfR
   */
  @PutMapping("/orderitems5s/{id}")
  public XfR putUpdate(@RequestBody Orderitems5 orderitems5,@PathVariable Long id) {
      orderitems5.setId(id);
      return XfR.ok(orderitems5ServiceImpl.updateById(orderitems5));
  }

  /**
   * 修改-传入修改的数据orderitems5
   * @param orderitems5 orderitems5
   * @return XfR
   */
  @PatchMapping("/orderitems5s/{id}")
  public XfR patchUpdate(@RequestBody Orderitems5 orderitems5,@PathVariable Long id) {
      Orderitems5 uporderitems5 = orderitems5ServiceImpl.getById(id);
      if(uporderitems5 != null){
        uporderitems5 = ObjectCopyUtils.copyProperties(orderitems5,uporderitems5,true);
      }
      return XfR.ok(orderitems5ServiceImpl.updateById(uporderitems5));
  }

  /**
   * 通过id删除orderitems5
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderitems5s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderitems5ServiceImpl.removeById(id));
  }

  @PostMapping("/orderitems5s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "orderitems5");
     params.put("request", condition);

     return XfR.ok(orderitems5ServiceImpl.querys(params));
  }

}
