package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Orderitems6;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrderitems6Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * orderitems6前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Orderitems6Controller {

  @Autowired
  private IOrderitems6Service orderitems6ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderitems6 orderitems6
   * @return
   */
  @GetMapping("/orderitems6s" )
  public XfR getOrderitems6s(XfPage page, Orderitems6 orderitems6) {
    return XfR.ok(orderitems6ServiceImpl.page(page, Wrappers.query(orderitems6)));
  }

  /**
   * 通过id查询orderitems6
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderitems6s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderitems6ServiceImpl.getById(id));
  }

  /**
   * 新增orderitems6
   * @param orderitems6 orderitems6
   * @return XfR
   */
  @PostMapping("/orderitems6s")
  public XfR save(@RequestBody Orderitems6 orderitems6) {
     return XfR.ok(orderitems6ServiceImpl.save(orderitems6));
  }

  /**
   * 修改-传入修改后的全部数据orderitems6
   * @param orderitems6 orderitems6
   * @return XfR
   */
  @PutMapping("/orderitems6s/{id}")
  public XfR putUpdate(@RequestBody Orderitems6 orderitems6,@PathVariable Long id) {
      orderitems6.setId(id);
      return XfR.ok(orderitems6ServiceImpl.updateById(orderitems6));
  }

  /**
   * 修改-传入修改的数据orderitems6
   * @param orderitems6 orderitems6
   * @return XfR
   */
  @PatchMapping("/orderitems6s/{id}")
  public XfR patchUpdate(@RequestBody Orderitems6 orderitems6,@PathVariable Long id) {
      Orderitems6 uporderitems6 = orderitems6ServiceImpl.getById(id);
      if(uporderitems6 != null){
        uporderitems6 = ObjectCopyUtils.copyProperties(orderitems6,uporderitems6,true);
      }
      return XfR.ok(orderitems6ServiceImpl.updateById(uporderitems6));
  }

  /**
   * 通过id删除orderitems6
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderitems6s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderitems6ServiceImpl.removeById(id));
  }

  @PostMapping("/orderitems6s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "orderitems6");
     params.put("request", condition);

     return XfR.ok(orderitems6ServiceImpl.querys(params));
  }

}
