package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Orderitems7;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrderitems7Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * orderitems7前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Orderitems7Controller {

  @Autowired
  private IOrderitems7Service orderitems7ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderitems7 orderitems7
   * @return
   */
  @GetMapping("/orderitems7s" )
  public XfR getOrderitems7s(XfPage page, Orderitems7 orderitems7) {
    return XfR.ok(orderitems7ServiceImpl.page(page, Wrappers.query(orderitems7)));
  }

  /**
   * 通过id查询orderitems7
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderitems7s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderitems7ServiceImpl.getById(id));
  }

  /**
   * 新增orderitems7
   * @param orderitems7 orderitems7
   * @return XfR
   */
  @PostMapping("/orderitems7s")
  public XfR save(@RequestBody Orderitems7 orderitems7) {
     return XfR.ok(orderitems7ServiceImpl.save(orderitems7));
  }

  /**
   * 修改-传入修改后的全部数据orderitems7
   * @param orderitems7 orderitems7
   * @return XfR
   */
  @PutMapping("/orderitems7s/{id}")
  public XfR putUpdate(@RequestBody Orderitems7 orderitems7,@PathVariable Long id) {
      orderitems7.setId(id);
      return XfR.ok(orderitems7ServiceImpl.updateById(orderitems7));
  }

  /**
   * 修改-传入修改的数据orderitems7
   * @param orderitems7 orderitems7
   * @return XfR
   */
  @PatchMapping("/orderitems7s/{id}")
  public XfR patchUpdate(@RequestBody Orderitems7 orderitems7,@PathVariable Long id) {
      Orderitems7 uporderitems7 = orderitems7ServiceImpl.getById(id);
      if(uporderitems7 != null){
        uporderitems7 = ObjectCopyUtils.copyProperties(orderitems7,uporderitems7,true);
      }
      return XfR.ok(orderitems7ServiceImpl.updateById(uporderitems7));
  }

  /**
   * 通过id删除orderitems7
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderitems7s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderitems7ServiceImpl.removeById(id));
  }

  @PostMapping("/orderitems7s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "orderitems7");
     params.put("request", condition);

     return XfR.ok(orderitems7ServiceImpl.querys(params));
  }

}
