package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Orderitems8;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrderitems8Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * orderitems8前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Orderitems8Controller {

  @Autowired
  private IOrderitems8Service orderitems8ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderitems8 orderitems8
   * @return
   */
  @GetMapping("/orderitems8s" )
  public XfR getOrderitems8s(XfPage page, Orderitems8 orderitems8) {
    return XfR.ok(orderitems8ServiceImpl.page(page, Wrappers.query(orderitems8)));
  }

  /**
   * 通过id查询orderitems8
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderitems8s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderitems8ServiceImpl.getById(id));
  }

  /**
   * 新增orderitems8
   * @param orderitems8 orderitems8
   * @return XfR
   */
  @PostMapping("/orderitems8s")
  public XfR save(@RequestBody Orderitems8 orderitems8) {
     return XfR.ok(orderitems8ServiceImpl.save(orderitems8));
  }

  /**
   * 修改-传入修改后的全部数据orderitems8
   * @param orderitems8 orderitems8
   * @return XfR
   */
  @PutMapping("/orderitems8s/{id}")
  public XfR putUpdate(@RequestBody Orderitems8 orderitems8,@PathVariable Long id) {
      orderitems8.setId(id);
      return XfR.ok(orderitems8ServiceImpl.updateById(orderitems8));
  }

  /**
   * 修改-传入修改的数据orderitems8
   * @param orderitems8 orderitems8
   * @return XfR
   */
  @PatchMapping("/orderitems8s/{id}")
  public XfR patchUpdate(@RequestBody Orderitems8 orderitems8,@PathVariable Long id) {
      Orderitems8 uporderitems8 = orderitems8ServiceImpl.getById(id);
      if(uporderitems8 != null){
        uporderitems8 = ObjectCopyUtils.copyProperties(orderitems8,uporderitems8,true);
      }
      return XfR.ok(orderitems8ServiceImpl.updateById(uporderitems8));
  }

  /**
   * 通过id删除orderitems8
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderitems8s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderitems8ServiceImpl.removeById(id));
  }

  @PostMapping("/orderitems8s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "orderitems8");
     params.put("request", condition);

     return XfR.ok(orderitems8ServiceImpl.querys(params));
  }

}
