package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Orderitems9;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrderitems9Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * orderitems9前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Orderitems9Controller {

  @Autowired
  private IOrderitems9Service orderitems9ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderitems9 orderitems9
   * @return
   */
  @GetMapping("/orderitems9s" )
  public XfR getOrderitems9s(XfPage page, Orderitems9 orderitems9) {
    return XfR.ok(orderitems9ServiceImpl.page(page, Wrappers.query(orderitems9)));
  }

  /**
   * 通过id查询orderitems9
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderitems9s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderitems9ServiceImpl.getById(id));
  }

  /**
   * 新增orderitems9
   * @param orderitems9 orderitems9
   * @return XfR
   */
  @PostMapping("/orderitems9s")
  public XfR save(@RequestBody Orderitems9 orderitems9) {
     return XfR.ok(orderitems9ServiceImpl.save(orderitems9));
  }

  /**
   * 修改-传入修改后的全部数据orderitems9
   * @param orderitems9 orderitems9
   * @return XfR
   */
  @PutMapping("/orderitems9s/{id}")
  public XfR putUpdate(@RequestBody Orderitems9 orderitems9,@PathVariable Long id) {
      orderitems9.setId(id);
      return XfR.ok(orderitems9ServiceImpl.updateById(orderitems9));
  }

  /**
   * 修改-传入修改的数据orderitems9
   * @param orderitems9 orderitems9
   * @return XfR
   */
  @PatchMapping("/orderitems9s/{id}")
  public XfR patchUpdate(@RequestBody Orderitems9 orderitems9,@PathVariable Long id) {
      Orderitems9 uporderitems9 = orderitems9ServiceImpl.getById(id);
      if(uporderitems9 != null){
        uporderitems9 = ObjectCopyUtils.copyProperties(orderitems9,uporderitems9,true);
      }
      return XfR.ok(orderitems9ServiceImpl.updateById(uporderitems9));
  }

  /**
   * 通过id删除orderitems9
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderitems9s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderitems9ServiceImpl.removeById(id));
  }

  @PostMapping("/orderitems9s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "orderitems9");
     params.put("request", condition);

     return XfR.ok(orderitems9ServiceImpl.querys(params));
  }

}
