package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Ordermain10;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrdermain10Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ordermain10前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Ordermain10Controller {

  @Autowired
  private IOrdermain10Service ordermain10ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordermain10 ordermain10
   * @return
   */
  @GetMapping("/ordermain10s" )
  public XfR getOrdermain10s(XfPage page, Ordermain10 ordermain10) {
    return XfR.ok(ordermain10ServiceImpl.page(page, Wrappers.query(ordermain10)));
  }

  /**
   * 通过id查询ordermain10
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordermain10s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordermain10ServiceImpl.getById(id));
  }

  /**
   * 新增ordermain10
   * @param ordermain10 ordermain10
   * @return XfR
   */
  @PostMapping("/ordermain10s")
  public XfR save(@RequestBody Ordermain10 ordermain10) {
     return XfR.ok(ordermain10ServiceImpl.save(ordermain10));
  }

  /**
   * 修改-传入修改后的全部数据ordermain10
   * @param ordermain10 ordermain10
   * @return XfR
   */
  @PutMapping("/ordermain10s/{id}")
  public XfR putUpdate(@RequestBody Ordermain10 ordermain10,@PathVariable Long id) {
      ordermain10.setId(id);
      return XfR.ok(ordermain10ServiceImpl.updateById(ordermain10));
  }

  /**
   * 修改-传入修改的数据ordermain10
   * @param ordermain10 ordermain10
   * @return XfR
   */
  @PatchMapping("/ordermain10s/{id}")
  public XfR patchUpdate(@RequestBody Ordermain10 ordermain10,@PathVariable Long id) {
      Ordermain10 upordermain10 = ordermain10ServiceImpl.getById(id);
      if(upordermain10 != null){
        upordermain10 = ObjectCopyUtils.copyProperties(ordermain10,upordermain10,true);
      }
      return XfR.ok(ordermain10ServiceImpl.updateById(upordermain10));
  }

  /**
   * 通过id删除ordermain10
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordermain10s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordermain10ServiceImpl.removeById(id));
  }

  @PostMapping("/ordermain10s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ordermain10");
     params.put("request", condition);

     return XfR.ok(ordermain10ServiceImpl.querys(params));
  }

}
