package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Ordermain11;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrdermain11Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ordermain11前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Ordermain11Controller {

  @Autowired
  private IOrdermain11Service ordermain11ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordermain11 ordermain11
   * @return
   */
  @GetMapping("/ordermain11s" )
  public XfR getOrdermain11s(XfPage page, Ordermain11 ordermain11) {
    return XfR.ok(ordermain11ServiceImpl.page(page, Wrappers.query(ordermain11)));
  }

  /**
   * 通过id查询ordermain11
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordermain11s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordermain11ServiceImpl.getById(id));
  }

  /**
   * 新增ordermain11
   * @param ordermain11 ordermain11
   * @return XfR
   */
  @PostMapping("/ordermain11s")
  public XfR save(@RequestBody Ordermain11 ordermain11) {
     return XfR.ok(ordermain11ServiceImpl.save(ordermain11));
  }

  /**
   * 修改-传入修改后的全部数据ordermain11
   * @param ordermain11 ordermain11
   * @return XfR
   */
  @PutMapping("/ordermain11s/{id}")
  public XfR putUpdate(@RequestBody Ordermain11 ordermain11,@PathVariable Long id) {
      ordermain11.setId(id);
      return XfR.ok(ordermain11ServiceImpl.updateById(ordermain11));
  }

  /**
   * 修改-传入修改的数据ordermain11
   * @param ordermain11 ordermain11
   * @return XfR
   */
  @PatchMapping("/ordermain11s/{id}")
  public XfR patchUpdate(@RequestBody Ordermain11 ordermain11,@PathVariable Long id) {
      Ordermain11 upordermain11 = ordermain11ServiceImpl.getById(id);
      if(upordermain11 != null){
        upordermain11 = ObjectCopyUtils.copyProperties(ordermain11,upordermain11,true);
      }
      return XfR.ok(ordermain11ServiceImpl.updateById(upordermain11));
  }

  /**
   * 通过id删除ordermain11
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordermain11s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordermain11ServiceImpl.removeById(id));
  }

  @PostMapping("/ordermain11s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ordermain11");
     params.put("request", condition);

     return XfR.ok(ordermain11ServiceImpl.querys(params));
  }

}
