package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Ordermain12;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrdermain12Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ordermain12前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Ordermain12Controller {

  @Autowired
  private IOrdermain12Service ordermain12ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordermain12 ordermain12
   * @return
   */
  @GetMapping("/ordermain12s" )
  public XfR getOrdermain12s(XfPage page, Ordermain12 ordermain12) {
    return XfR.ok(ordermain12ServiceImpl.page(page, Wrappers.query(ordermain12)));
  }

  /**
   * 通过id查询ordermain12
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordermain12s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordermain12ServiceImpl.getById(id));
  }

  /**
   * 新增ordermain12
   * @param ordermain12 ordermain12
   * @return XfR
   */
  @PostMapping("/ordermain12s")
  public XfR save(@RequestBody Ordermain12 ordermain12) {
     return XfR.ok(ordermain12ServiceImpl.save(ordermain12));
  }

  /**
   * 修改-传入修改后的全部数据ordermain12
   * @param ordermain12 ordermain12
   * @return XfR
   */
  @PutMapping("/ordermain12s/{id}")
  public XfR putUpdate(@RequestBody Ordermain12 ordermain12,@PathVariable Long id) {
      ordermain12.setId(id);
      return XfR.ok(ordermain12ServiceImpl.updateById(ordermain12));
  }

  /**
   * 修改-传入修改的数据ordermain12
   * @param ordermain12 ordermain12
   * @return XfR
   */
  @PatchMapping("/ordermain12s/{id}")
  public XfR patchUpdate(@RequestBody Ordermain12 ordermain12,@PathVariable Long id) {
      Ordermain12 upordermain12 = ordermain12ServiceImpl.getById(id);
      if(upordermain12 != null){
        upordermain12 = ObjectCopyUtils.copyProperties(ordermain12,upordermain12,true);
      }
      return XfR.ok(ordermain12ServiceImpl.updateById(upordermain12));
  }

  /**
   * 通过id删除ordermain12
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordermain12s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordermain12ServiceImpl.removeById(id));
  }

  @PostMapping("/ordermain12s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ordermain12");
     params.put("request", condition);

     return XfR.ok(ordermain12ServiceImpl.querys(params));
  }

}
