package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Ordermain13;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrdermain13Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ordermain13前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Ordermain13Controller {

  @Autowired
  private IOrdermain13Service ordermain13ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordermain13 ordermain13
   * @return
   */
  @GetMapping("/ordermain13s" )
  public XfR getOrdermain13s(XfPage page, Ordermain13 ordermain13) {
    return XfR.ok(ordermain13ServiceImpl.page(page, Wrappers.query(ordermain13)));
  }

  /**
   * 通过id查询ordermain13
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordermain13s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordermain13ServiceImpl.getById(id));
  }

  /**
   * 新增ordermain13
   * @param ordermain13 ordermain13
   * @return XfR
   */
  @PostMapping("/ordermain13s")
  public XfR save(@RequestBody Ordermain13 ordermain13) {
     return XfR.ok(ordermain13ServiceImpl.save(ordermain13));
  }

  /**
   * 修改-传入修改后的全部数据ordermain13
   * @param ordermain13 ordermain13
   * @return XfR
   */
  @PutMapping("/ordermain13s/{id}")
  public XfR putUpdate(@RequestBody Ordermain13 ordermain13,@PathVariable Long id) {
      ordermain13.setId(id);
      return XfR.ok(ordermain13ServiceImpl.updateById(ordermain13));
  }

  /**
   * 修改-传入修改的数据ordermain13
   * @param ordermain13 ordermain13
   * @return XfR
   */
  @PatchMapping("/ordermain13s/{id}")
  public XfR patchUpdate(@RequestBody Ordermain13 ordermain13,@PathVariable Long id) {
      Ordermain13 upordermain13 = ordermain13ServiceImpl.getById(id);
      if(upordermain13 != null){
        upordermain13 = ObjectCopyUtils.copyProperties(ordermain13,upordermain13,true);
      }
      return XfR.ok(ordermain13ServiceImpl.updateById(upordermain13));
  }

  /**
   * 通过id删除ordermain13
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordermain13s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordermain13ServiceImpl.removeById(id));
  }

  @PostMapping("/ordermain13s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ordermain13");
     params.put("request", condition);

     return XfR.ok(ordermain13ServiceImpl.querys(params));
  }

}
