package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Ordermain14;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrdermain14Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ordermain14前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Ordermain14Controller {

  @Autowired
  private IOrdermain14Service ordermain14ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordermain14 ordermain14
   * @return
   */
  @GetMapping("/ordermain14s" )
  public XfR getOrdermain14s(XfPage page, Ordermain14 ordermain14) {
    return XfR.ok(ordermain14ServiceImpl.page(page, Wrappers.query(ordermain14)));
  }

  /**
   * 通过id查询ordermain14
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordermain14s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordermain14ServiceImpl.getById(id));
  }

  /**
   * 新增ordermain14
   * @param ordermain14 ordermain14
   * @return XfR
   */
  @PostMapping("/ordermain14s")
  public XfR save(@RequestBody Ordermain14 ordermain14) {
     return XfR.ok(ordermain14ServiceImpl.save(ordermain14));
  }

  /**
   * 修改-传入修改后的全部数据ordermain14
   * @param ordermain14 ordermain14
   * @return XfR
   */
  @PutMapping("/ordermain14s/{id}")
  public XfR putUpdate(@RequestBody Ordermain14 ordermain14,@PathVariable Long id) {
      ordermain14.setId(id);
      return XfR.ok(ordermain14ServiceImpl.updateById(ordermain14));
  }

  /**
   * 修改-传入修改的数据ordermain14
   * @param ordermain14 ordermain14
   * @return XfR
   */
  @PatchMapping("/ordermain14s/{id}")
  public XfR patchUpdate(@RequestBody Ordermain14 ordermain14,@PathVariable Long id) {
      Ordermain14 upordermain14 = ordermain14ServiceImpl.getById(id);
      if(upordermain14 != null){
        upordermain14 = ObjectCopyUtils.copyProperties(ordermain14,upordermain14,true);
      }
      return XfR.ok(ordermain14ServiceImpl.updateById(upordermain14));
  }

  /**
   * 通过id删除ordermain14
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordermain14s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordermain14ServiceImpl.removeById(id));
  }

  @PostMapping("/ordermain14s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ordermain14");
     params.put("request", condition);

     return XfR.ok(ordermain14ServiceImpl.querys(params));
  }

}
