package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Ordermain1;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrdermain1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ordermain1前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Ordermain1Controller {

  @Autowired
  private IOrdermain1Service ordermain1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordermain1 ordermain1
   * @return
   */
  @GetMapping("/ordermain1s" )
  public XfR getOrdermain1s(XfPage page, Ordermain1 ordermain1) {
    return XfR.ok(ordermain1ServiceImpl.page(page, Wrappers.query(ordermain1)));
  }

  /**
   * 通过id查询ordermain1
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordermain1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordermain1ServiceImpl.getById(id));
  }

  /**
   * 新增ordermain1
   * @param ordermain1 ordermain1
   * @return XfR
   */
  @PostMapping("/ordermain1s")
  public XfR save(@RequestBody Ordermain1 ordermain1) {
     return XfR.ok(ordermain1ServiceImpl.save(ordermain1));
  }

  /**
   * 修改-传入修改后的全部数据ordermain1
   * @param ordermain1 ordermain1
   * @return XfR
   */
  @PutMapping("/ordermain1s/{id}")
  public XfR putUpdate(@RequestBody Ordermain1 ordermain1,@PathVariable Long id) {
      ordermain1.setId(id);
      return XfR.ok(ordermain1ServiceImpl.updateById(ordermain1));
  }

  /**
   * 修改-传入修改的数据ordermain1
   * @param ordermain1 ordermain1
   * @return XfR
   */
  @PatchMapping("/ordermain1s/{id}")
  public XfR patchUpdate(@RequestBody Ordermain1 ordermain1,@PathVariable Long id) {
      Ordermain1 upordermain1 = ordermain1ServiceImpl.getById(id);
      if(upordermain1 != null){
        upordermain1 = ObjectCopyUtils.copyProperties(ordermain1,upordermain1,true);
      }
      return XfR.ok(ordermain1ServiceImpl.updateById(upordermain1));
  }

  /**
   * 通过id删除ordermain1
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordermain1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordermain1ServiceImpl.removeById(id));
  }

  @PostMapping("/ordermain1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ordermain1");
     params.put("request", condition);

     return XfR.ok(ordermain1ServiceImpl.querys(params));
  }

}
