package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Ordermain2;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrdermain2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ordermain2前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Ordermain2Controller {

  @Autowired
  private IOrdermain2Service ordermain2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordermain2 ordermain2
   * @return
   */
  @GetMapping("/ordermain2s" )
  public XfR getOrdermain2s(XfPage page, Ordermain2 ordermain2) {
    return XfR.ok(ordermain2ServiceImpl.page(page, Wrappers.query(ordermain2)));
  }

  /**
   * 通过id查询ordermain2
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordermain2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordermain2ServiceImpl.getById(id));
  }

  /**
   * 新增ordermain2
   * @param ordermain2 ordermain2
   * @return XfR
   */
  @PostMapping("/ordermain2s")
  public XfR save(@RequestBody Ordermain2 ordermain2) {
     return XfR.ok(ordermain2ServiceImpl.save(ordermain2));
  }

  /**
   * 修改-传入修改后的全部数据ordermain2
   * @param ordermain2 ordermain2
   * @return XfR
   */
  @PutMapping("/ordermain2s/{id}")
  public XfR putUpdate(@RequestBody Ordermain2 ordermain2,@PathVariable Long id) {
      ordermain2.setId(id);
      return XfR.ok(ordermain2ServiceImpl.updateById(ordermain2));
  }

  /**
   * 修改-传入修改的数据ordermain2
   * @param ordermain2 ordermain2
   * @return XfR
   */
  @PatchMapping("/ordermain2s/{id}")
  public XfR patchUpdate(@RequestBody Ordermain2 ordermain2,@PathVariable Long id) {
      Ordermain2 upordermain2 = ordermain2ServiceImpl.getById(id);
      if(upordermain2 != null){
        upordermain2 = ObjectCopyUtils.copyProperties(ordermain2,upordermain2,true);
      }
      return XfR.ok(ordermain2ServiceImpl.updateById(upordermain2));
  }

  /**
   * 通过id删除ordermain2
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordermain2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordermain2ServiceImpl.removeById(id));
  }

  @PostMapping("/ordermain2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ordermain2");
     params.put("request", condition);

     return XfR.ok(ordermain2ServiceImpl.querys(params));
  }

}
