package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Ordermain3;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrdermain3Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ordermain3前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Ordermain3Controller {

  @Autowired
  private IOrdermain3Service ordermain3ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordermain3 ordermain3
   * @return
   */
  @GetMapping("/ordermain3s" )
  public XfR getOrdermain3s(XfPage page, Ordermain3 ordermain3) {
    return XfR.ok(ordermain3ServiceImpl.page(page, Wrappers.query(ordermain3)));
  }

  /**
   * 通过id查询ordermain3
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordermain3s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordermain3ServiceImpl.getById(id));
  }

  /**
   * 新增ordermain3
   * @param ordermain3 ordermain3
   * @return XfR
   */
  @PostMapping("/ordermain3s")
  public XfR save(@RequestBody Ordermain3 ordermain3) {
     return XfR.ok(ordermain3ServiceImpl.save(ordermain3));
  }

  /**
   * 修改-传入修改后的全部数据ordermain3
   * @param ordermain3 ordermain3
   * @return XfR
   */
  @PutMapping("/ordermain3s/{id}")
  public XfR putUpdate(@RequestBody Ordermain3 ordermain3,@PathVariable Long id) {
      ordermain3.setId(id);
      return XfR.ok(ordermain3ServiceImpl.updateById(ordermain3));
  }

  /**
   * 修改-传入修改的数据ordermain3
   * @param ordermain3 ordermain3
   * @return XfR
   */
  @PatchMapping("/ordermain3s/{id}")
  public XfR patchUpdate(@RequestBody Ordermain3 ordermain3,@PathVariable Long id) {
      Ordermain3 upordermain3 = ordermain3ServiceImpl.getById(id);
      if(upordermain3 != null){
        upordermain3 = ObjectCopyUtils.copyProperties(ordermain3,upordermain3,true);
      }
      return XfR.ok(ordermain3ServiceImpl.updateById(upordermain3));
  }

  /**
   * 通过id删除ordermain3
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordermain3s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordermain3ServiceImpl.removeById(id));
  }

  @PostMapping("/ordermain3s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ordermain3");
     params.put("request", condition);

     return XfR.ok(ordermain3ServiceImpl.querys(params));
  }

}
