package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Ordermain4;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrdermain4Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ordermain4前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Ordermain4Controller {

  @Autowired
  private IOrdermain4Service ordermain4ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordermain4 ordermain4
   * @return
   */
  @GetMapping("/ordermain4s" )
  public XfR getOrdermain4s(XfPage page, Ordermain4 ordermain4) {
    return XfR.ok(ordermain4ServiceImpl.page(page, Wrappers.query(ordermain4)));
  }

  /**
   * 通过id查询ordermain4
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordermain4s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordermain4ServiceImpl.getById(id));
  }

  /**
   * 新增ordermain4
   * @param ordermain4 ordermain4
   * @return XfR
   */
  @PostMapping("/ordermain4s")
  public XfR save(@RequestBody Ordermain4 ordermain4) {
     return XfR.ok(ordermain4ServiceImpl.save(ordermain4));
  }

  /**
   * 修改-传入修改后的全部数据ordermain4
   * @param ordermain4 ordermain4
   * @return XfR
   */
  @PutMapping("/ordermain4s/{id}")
  public XfR putUpdate(@RequestBody Ordermain4 ordermain4,@PathVariable Long id) {
      ordermain4.setId(id);
      return XfR.ok(ordermain4ServiceImpl.updateById(ordermain4));
  }

  /**
   * 修改-传入修改的数据ordermain4
   * @param ordermain4 ordermain4
   * @return XfR
   */
  @PatchMapping("/ordermain4s/{id}")
  public XfR patchUpdate(@RequestBody Ordermain4 ordermain4,@PathVariable Long id) {
      Ordermain4 upordermain4 = ordermain4ServiceImpl.getById(id);
      if(upordermain4 != null){
        upordermain4 = ObjectCopyUtils.copyProperties(ordermain4,upordermain4,true);
      }
      return XfR.ok(ordermain4ServiceImpl.updateById(upordermain4));
  }

  /**
   * 通过id删除ordermain4
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordermain4s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordermain4ServiceImpl.removeById(id));
  }

  @PostMapping("/ordermain4s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ordermain4");
     params.put("request", condition);

     return XfR.ok(ordermain4ServiceImpl.querys(params));
  }

}
