package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Ordermain5;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrdermain5Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ordermain5前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Ordermain5Controller {

  @Autowired
  private IOrdermain5Service ordermain5ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordermain5 ordermain5
   * @return
   */
  @GetMapping("/ordermain5s" )
  public XfR getOrdermain5s(XfPage page, Ordermain5 ordermain5) {
    return XfR.ok(ordermain5ServiceImpl.page(page, Wrappers.query(ordermain5)));
  }

  /**
   * 通过id查询ordermain5
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordermain5s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordermain5ServiceImpl.getById(id));
  }

  /**
   * 新增ordermain5
   * @param ordermain5 ordermain5
   * @return XfR
   */
  @PostMapping("/ordermain5s")
  public XfR save(@RequestBody Ordermain5 ordermain5) {
     return XfR.ok(ordermain5ServiceImpl.save(ordermain5));
  }

  /**
   * 修改-传入修改后的全部数据ordermain5
   * @param ordermain5 ordermain5
   * @return XfR
   */
  @PutMapping("/ordermain5s/{id}")
  public XfR putUpdate(@RequestBody Ordermain5 ordermain5,@PathVariable Long id) {
      ordermain5.setId(id);
      return XfR.ok(ordermain5ServiceImpl.updateById(ordermain5));
  }

  /**
   * 修改-传入修改的数据ordermain5
   * @param ordermain5 ordermain5
   * @return XfR
   */
  @PatchMapping("/ordermain5s/{id}")
  public XfR patchUpdate(@RequestBody Ordermain5 ordermain5,@PathVariable Long id) {
      Ordermain5 upordermain5 = ordermain5ServiceImpl.getById(id);
      if(upordermain5 != null){
        upordermain5 = ObjectCopyUtils.copyProperties(ordermain5,upordermain5,true);
      }
      return XfR.ok(ordermain5ServiceImpl.updateById(upordermain5));
  }

  /**
   * 通过id删除ordermain5
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordermain5s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordermain5ServiceImpl.removeById(id));
  }

  @PostMapping("/ordermain5s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ordermain5");
     params.put("request", condition);

     return XfR.ok(ordermain5ServiceImpl.querys(params));
  }

}
