package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Ordermain6;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrdermain6Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ordermain6前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Ordermain6Controller {

  @Autowired
  private IOrdermain6Service ordermain6ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordermain6 ordermain6
   * @return
   */
  @GetMapping("/ordermain6s" )
  public XfR getOrdermain6s(XfPage page, Ordermain6 ordermain6) {
    return XfR.ok(ordermain6ServiceImpl.page(page, Wrappers.query(ordermain6)));
  }

  /**
   * 通过id查询ordermain6
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordermain6s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordermain6ServiceImpl.getById(id));
  }

  /**
   * 新增ordermain6
   * @param ordermain6 ordermain6
   * @return XfR
   */
  @PostMapping("/ordermain6s")
  public XfR save(@RequestBody Ordermain6 ordermain6) {
     return XfR.ok(ordermain6ServiceImpl.save(ordermain6));
  }

  /**
   * 修改-传入修改后的全部数据ordermain6
   * @param ordermain6 ordermain6
   * @return XfR
   */
  @PutMapping("/ordermain6s/{id}")
  public XfR putUpdate(@RequestBody Ordermain6 ordermain6,@PathVariable Long id) {
      ordermain6.setId(id);
      return XfR.ok(ordermain6ServiceImpl.updateById(ordermain6));
  }

  /**
   * 修改-传入修改的数据ordermain6
   * @param ordermain6 ordermain6
   * @return XfR
   */
  @PatchMapping("/ordermain6s/{id}")
  public XfR patchUpdate(@RequestBody Ordermain6 ordermain6,@PathVariable Long id) {
      Ordermain6 upordermain6 = ordermain6ServiceImpl.getById(id);
      if(upordermain6 != null){
        upordermain6 = ObjectCopyUtils.copyProperties(ordermain6,upordermain6,true);
      }
      return XfR.ok(ordermain6ServiceImpl.updateById(upordermain6));
  }

  /**
   * 通过id删除ordermain6
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordermain6s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordermain6ServiceImpl.removeById(id));
  }

  @PostMapping("/ordermain6s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ordermain6");
     params.put("request", condition);

     return XfR.ok(ordermain6ServiceImpl.querys(params));
  }

}
