package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Ordermain7;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrdermain7Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ordermain7前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Ordermain7Controller {

  @Autowired
  private IOrdermain7Service ordermain7ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordermain7 ordermain7
   * @return
   */
  @GetMapping("/ordermain7s" )
  public XfR getOrdermain7s(XfPage page, Ordermain7 ordermain7) {
    return XfR.ok(ordermain7ServiceImpl.page(page, Wrappers.query(ordermain7)));
  }

  /**
   * 通过id查询ordermain7
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordermain7s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordermain7ServiceImpl.getById(id));
  }

  /**
   * 新增ordermain7
   * @param ordermain7 ordermain7
   * @return XfR
   */
  @PostMapping("/ordermain7s")
  public XfR save(@RequestBody Ordermain7 ordermain7) {
     return XfR.ok(ordermain7ServiceImpl.save(ordermain7));
  }

  /**
   * 修改-传入修改后的全部数据ordermain7
   * @param ordermain7 ordermain7
   * @return XfR
   */
  @PutMapping("/ordermain7s/{id}")
  public XfR putUpdate(@RequestBody Ordermain7 ordermain7,@PathVariable Long id) {
      ordermain7.setId(id);
      return XfR.ok(ordermain7ServiceImpl.updateById(ordermain7));
  }

  /**
   * 修改-传入修改的数据ordermain7
   * @param ordermain7 ordermain7
   * @return XfR
   */
  @PatchMapping("/ordermain7s/{id}")
  public XfR patchUpdate(@RequestBody Ordermain7 ordermain7,@PathVariable Long id) {
      Ordermain7 upordermain7 = ordermain7ServiceImpl.getById(id);
      if(upordermain7 != null){
        upordermain7 = ObjectCopyUtils.copyProperties(ordermain7,upordermain7,true);
      }
      return XfR.ok(ordermain7ServiceImpl.updateById(upordermain7));
  }

  /**
   * 通过id删除ordermain7
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordermain7s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordermain7ServiceImpl.removeById(id));
  }

  @PostMapping("/ordermain7s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ordermain7");
     params.put("request", condition);

     return XfR.ok(ordermain7ServiceImpl.querys(params));
  }

}
