package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Ordermain8;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrdermain8Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ordermain8前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Ordermain8Controller {

  @Autowired
  private IOrdermain8Service ordermain8ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordermain8 ordermain8
   * @return
   */
  @GetMapping("/ordermain8s" )
  public XfR getOrdermain8s(XfPage page, Ordermain8 ordermain8) {
    return XfR.ok(ordermain8ServiceImpl.page(page, Wrappers.query(ordermain8)));
  }

  /**
   * 通过id查询ordermain8
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordermain8s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordermain8ServiceImpl.getById(id));
  }

  /**
   * 新增ordermain8
   * @param ordermain8 ordermain8
   * @return XfR
   */
  @PostMapping("/ordermain8s")
  public XfR save(@RequestBody Ordermain8 ordermain8) {
     return XfR.ok(ordermain8ServiceImpl.save(ordermain8));
  }

  /**
   * 修改-传入修改后的全部数据ordermain8
   * @param ordermain8 ordermain8
   * @return XfR
   */
  @PutMapping("/ordermain8s/{id}")
  public XfR putUpdate(@RequestBody Ordermain8 ordermain8,@PathVariable Long id) {
      ordermain8.setId(id);
      return XfR.ok(ordermain8ServiceImpl.updateById(ordermain8));
  }

  /**
   * 修改-传入修改的数据ordermain8
   * @param ordermain8 ordermain8
   * @return XfR
   */
  @PatchMapping("/ordermain8s/{id}")
  public XfR patchUpdate(@RequestBody Ordermain8 ordermain8,@PathVariable Long id) {
      Ordermain8 upordermain8 = ordermain8ServiceImpl.getById(id);
      if(upordermain8 != null){
        upordermain8 = ObjectCopyUtils.copyProperties(ordermain8,upordermain8,true);
      }
      return XfR.ok(ordermain8ServiceImpl.updateById(upordermain8));
  }

  /**
   * 通过id删除ordermain8
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordermain8s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordermain8ServiceImpl.removeById(id));
  }

  @PostMapping("/ordermain8s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ordermain8");
     params.put("request", condition);

     return XfR.ok(ordermain8ServiceImpl.querys(params));
  }

}
