package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Ordermain9;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrdermain9Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ordermain9前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Ordermain9Controller {

  @Autowired
  private IOrdermain9Service ordermain9ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordermain9 ordermain9
   * @return
   */
  @GetMapping("/ordermain9s" )
  public XfR getOrdermain9s(XfPage page, Ordermain9 ordermain9) {
    return XfR.ok(ordermain9ServiceImpl.page(page, Wrappers.query(ordermain9)));
  }

  /**
   * 通过id查询ordermain9
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordermain9s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordermain9ServiceImpl.getById(id));
  }

  /**
   * 新增ordermain9
   * @param ordermain9 ordermain9
   * @return XfR
   */
  @PostMapping("/ordermain9s")
  public XfR save(@RequestBody Ordermain9 ordermain9) {
     return XfR.ok(ordermain9ServiceImpl.save(ordermain9));
  }

  /**
   * 修改-传入修改后的全部数据ordermain9
   * @param ordermain9 ordermain9
   * @return XfR
   */
  @PutMapping("/ordermain9s/{id}")
  public XfR putUpdate(@RequestBody Ordermain9 ordermain9,@PathVariable Long id) {
      ordermain9.setId(id);
      return XfR.ok(ordermain9ServiceImpl.updateById(ordermain9));
  }

  /**
   * 修改-传入修改的数据ordermain9
   * @param ordermain9 ordermain9
   * @return XfR
   */
  @PatchMapping("/ordermain9s/{id}")
  public XfR patchUpdate(@RequestBody Ordermain9 ordermain9,@PathVariable Long id) {
      Ordermain9 upordermain9 = ordermain9ServiceImpl.getById(id);
      if(upordermain9 != null){
        upordermain9 = ObjectCopyUtils.copyProperties(ordermain9,upordermain9,true);
      }
      return XfR.ok(ordermain9ServiceImpl.updateById(upordermain9));
  }

  /**
   * 通过id删除ordermain9
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordermain9s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordermain9ServiceImpl.removeById(id));
  }

  @PostMapping("/ordermain9s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ordermain9");
     params.put("request", condition);

     return XfR.ok(ordermain9ServiceImpl.querys(params));
  }

}
