package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Ordermain;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IOrdermainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ordermain前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class OrdermainController {

  @Autowired
  private IOrdermainService ordermainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordermain ordermain
   * @return
   */
  @GetMapping("/ordermains" )
  public XfR getOrdermains(XfPage page, Ordermain ordermain) {
    return XfR.ok(ordermainServiceImpl.page(page, Wrappers.query(ordermain)));
  }

  /**
   * 通过id查询ordermain
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordermains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordermainServiceImpl.getById(id));
  }

  /**
   * 新增ordermain
   * @param ordermain ordermain
   * @return XfR
   */
  @PostMapping("/ordermains")
  public XfR save(@RequestBody Ordermain ordermain) {
     return XfR.ok(ordermainServiceImpl.save(ordermain));
  }

  /**
   * 修改-传入修改后的全部数据ordermain
   * @param ordermain ordermain
   * @return XfR
   */
  @PutMapping("/ordermains/{id}")
  public XfR putUpdate(@RequestBody Ordermain ordermain,@PathVariable Long id) {
      ordermain.setId(id);
      return XfR.ok(ordermainServiceImpl.updateById(ordermain));
  }

  /**
   * 修改-传入修改的数据ordermain
   * @param ordermain ordermain
   * @return XfR
   */
  @PatchMapping("/ordermains/{id}")
  public XfR patchUpdate(@RequestBody Ordermain ordermain,@PathVariable Long id) {
      Ordermain upordermain = ordermainServiceImpl.getById(id);
      if(upordermain != null){
        upordermain = ObjectCopyUtils.copyProperties(ordermain,upordermain,true);
      }
      return XfR.ok(ordermainServiceImpl.updateById(upordermain));
  }

  /**
   * 通过id删除ordermain
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordermains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordermainServiceImpl.removeById(id));
  }

  @PostMapping("/ordermains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ordermain");
     params.put("request", condition);

     return XfR.ok(ordermainServiceImpl.querys(params));
  }

}
