package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.PurchaseFailedHistory;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IPurchaseFailedHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class PurchaseFailedHistoryController {

  @Autowired
  private IPurchaseFailedHistoryService purchaseFailedHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param purchaseFailedHistory ${table.comment}
   * @return
   */
  @GetMapping("/purchasefailedhistorys" )
  public XfR getPurchaseFailedHistorys(XfPage page, PurchaseFailedHistory purchaseFailedHistory) {
    return XfR.ok(purchaseFailedHistoryServiceImpl.page(page, Wrappers.query(purchaseFailedHistory)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/purchasefailedhistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(purchaseFailedHistoryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param purchaseFailedHistory ${table.comment}
   * @return XfR
   */
  @PostMapping("/purchasefailedhistorys")
  public XfR save(@RequestBody PurchaseFailedHistory purchaseFailedHistory) {
     return XfR.ok(purchaseFailedHistoryServiceImpl.save(purchaseFailedHistory));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param purchaseFailedHistory ${table.comment}
   * @return XfR
   */
  @PutMapping("/purchasefailedhistorys/{id}")
  public XfR putUpdate(@RequestBody PurchaseFailedHistory purchaseFailedHistory,@PathVariable Long id) {
      purchaseFailedHistory.setId(id);
      return XfR.ok(purchaseFailedHistoryServiceImpl.updateById(purchaseFailedHistory));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param purchaseFailedHistory ${table.comment}
   * @return XfR
   */
  @PatchMapping("/purchasefailedhistorys/{id}")
  public XfR patchUpdate(@RequestBody PurchaseFailedHistory purchaseFailedHistory,@PathVariable Long id) {
      PurchaseFailedHistory uppurchaseFailedHistory = purchaseFailedHistoryServiceImpl.getById(id);
      if(uppurchaseFailedHistory != null){
        uppurchaseFailedHistory = ObjectCopyUtils.copyProperties(purchaseFailedHistory,uppurchaseFailedHistory,true);
      }
      return XfR.ok(purchaseFailedHistoryServiceImpl.updateById(uppurchaseFailedHistory));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/purchasefailedhistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(purchaseFailedHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/purchasefailedhistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "purchase_failed_history");
     params.put("request", condition);

     return XfR.ok(purchaseFailedHistoryServiceImpl.querys(params));
  }

}
