package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Schoolall;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ISchoolallService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * schoolall前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class SchoolallController {

  @Autowired
  private ISchoolallService schoolallServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param schoolall schoolall
   * @return
   */
  @GetMapping("/schoolalls" )
  public XfR getSchoolalls(XfPage page, Schoolall schoolall) {
    return XfR.ok(schoolallServiceImpl.page(page, Wrappers.query(schoolall)));
  }

  /**
   * 通过id查询schoolall
   * @param  id
   * @return XfR
   */
  @GetMapping("/schoolalls/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(schoolallServiceImpl.getById(id));
  }

  /**
   * 新增schoolall
   * @param schoolall schoolall
   * @return XfR
   */
  @PostMapping("/schoolalls")
  public XfR save(@RequestBody Schoolall schoolall) {
     return XfR.ok(schoolallServiceImpl.save(schoolall));
  }

  /**
   * 修改-传入修改后的全部数据schoolall
   * @param schoolall schoolall
   * @return XfR
   */
  @PutMapping("/schoolalls/{id}")
  public XfR putUpdate(@RequestBody Schoolall schoolall,@PathVariable Long id) {
      schoolall.setId(id);
      return XfR.ok(schoolallServiceImpl.updateById(schoolall));
  }

  /**
   * 修改-传入修改的数据schoolall
   * @param schoolall schoolall
   * @return XfR
   */
  @PatchMapping("/schoolalls/{id}")
  public XfR patchUpdate(@RequestBody Schoolall schoolall,@PathVariable Long id) {
      Schoolall upschoolall = schoolallServiceImpl.getById(id);
      if(upschoolall != null){
        upschoolall = ObjectCopyUtils.copyProperties(schoolall,upschoolall,true);
      }
      return XfR.ok(schoolallServiceImpl.updateById(upschoolall));
  }

  /**
   * 通过id删除schoolall
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/schoolalls/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(schoolallServiceImpl.removeById(id));
  }

  @PostMapping("/schoolalls/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "schoolall");
     params.put("request", condition);

     return XfR.ok(schoolallServiceImpl.querys(params));
  }

}
