package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Test0118;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ITest0118Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * test0118前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Test0118Controller {

  @Autowired
  private ITest0118Service test0118ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test0118 test0118
   * @return
   */
  @GetMapping("/test0118s" )
  public XfR getTest0118s(XfPage page, Test0118 test0118) {
    return XfR.ok(test0118ServiceImpl.page(page, Wrappers.query(test0118)));
  }

  /**
   * 通过id查询test0118
   * @param  id
   * @return XfR
   */
  @GetMapping("/test0118s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test0118ServiceImpl.getById(id));
  }

  /**
   * 新增test0118
   * @param test0118 test0118
   * @return XfR
   */
  @PostMapping("/test0118s")
  public XfR save(@RequestBody Test0118 test0118) {
     return XfR.ok(test0118ServiceImpl.save(test0118));
  }

  /**
   * 修改-传入修改后的全部数据test0118
   * @param test0118 test0118
   * @return XfR
   */
  @PutMapping("/test0118s/{id}")
  public XfR putUpdate(@RequestBody Test0118 test0118,@PathVariable Long id) {
      test0118.setId(id);
      return XfR.ok(test0118ServiceImpl.updateById(test0118));
  }

  /**
   * 修改-传入修改的数据test0118
   * @param test0118 test0118
   * @return XfR
   */
  @PatchMapping("/test0118s/{id}")
  public XfR patchUpdate(@RequestBody Test0118 test0118,@PathVariable Long id) {
      Test0118 uptest0118 = test0118ServiceImpl.getById(id);
      if(uptest0118 != null){
        uptest0118 = ObjectCopyUtils.copyProperties(test0118,uptest0118,true);
      }
      return XfR.ok(test0118ServiceImpl.updateById(uptest0118));
  }

  /**
   * 通过id删除test0118
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test0118s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test0118ServiceImpl.removeById(id));
  }

  @PostMapping("/test0118s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test0118");
     params.put("request", condition);

     return XfR.ok(test0118ServiceImpl.querys(params));
  }

}
