package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Test0224;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ITest0224Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * test0224前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Test0224Controller {

  @Autowired
  private ITest0224Service test0224ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test0224 test0224
   * @return
   */
  @GetMapping("/test0224s" )
  public XfR getTest0224s(XfPage page, Test0224 test0224) {
    return XfR.ok(test0224ServiceImpl.page(page, Wrappers.query(test0224)));
  }

  /**
   * 通过id查询test0224
   * @param  id
   * @return XfR
   */
  @GetMapping("/test0224s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test0224ServiceImpl.getById(id));
  }

  /**
   * 新增test0224
   * @param test0224 test0224
   * @return XfR
   */
  @PostMapping("/test0224s")
  public XfR save(@RequestBody Test0224 test0224) {
     return XfR.ok(test0224ServiceImpl.save(test0224));
  }

  /**
   * 修改-传入修改后的全部数据test0224
   * @param test0224 test0224
   * @return XfR
   */
  @PutMapping("/test0224s/{id}")
  public XfR putUpdate(@RequestBody Test0224 test0224,@PathVariable Long id) {
      test0224.setId(id);
      return XfR.ok(test0224ServiceImpl.updateById(test0224));
  }

  /**
   * 修改-传入修改的数据test0224
   * @param test0224 test0224
   * @return XfR
   */
  @PatchMapping("/test0224s/{id}")
  public XfR patchUpdate(@RequestBody Test0224 test0224,@PathVariable Long id) {
      Test0224 uptest0224 = test0224ServiceImpl.getById(id);
      if(uptest0224 != null){
        uptest0224 = ObjectCopyUtils.copyProperties(test0224,uptest0224,true);
      }
      return XfR.ok(test0224ServiceImpl.updateById(uptest0224));
  }

  /**
   * 通过id删除test0224
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test0224s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test0224ServiceImpl.removeById(id));
  }

  @PostMapping("/test0224s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test0224");
     params.put("request", condition);

     return XfR.ok(test0224ServiceImpl.querys(params));
  }

}
